package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class HostAliasBuilder extends io.fabric8.kubernetes.api.model.HostAliasFluentImpl<io.fabric8.kubernetes.api.model.HostAliasBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.HostAlias,io.fabric8.kubernetes.api.model.HostAliasBuilder> {

    io.fabric8.kubernetes.api.model.HostAliasFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public HostAliasBuilder() {
        this(true);
    }

    public HostAliasBuilder(java.lang.Boolean validationEnabled) {
        this(new HostAlias(), validationEnabled);
    }

    public HostAliasBuilder(io.fabric8.kubernetes.api.model.HostAliasFluent<?> fluent) {
        this(fluent, true);
    }

    public HostAliasBuilder(io.fabric8.kubernetes.api.model.HostAliasFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new HostAlias(), validationEnabled);
    }

    public HostAliasBuilder(io.fabric8.kubernetes.api.model.HostAliasFluent<?> fluent,io.fabric8.kubernetes.api.model.HostAlias instance) {
        this(fluent, instance, true);
    }

    public HostAliasBuilder(io.fabric8.kubernetes.api.model.HostAliasFluent<?> fluent,io.fabric8.kubernetes.api.model.HostAlias instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withHostnames(instance.getHostnames()); 
        fluent.withIp(instance.getIp()); 
        this.validationEnabled = validationEnabled; 
    }

    public HostAliasBuilder(io.fabric8.kubernetes.api.model.HostAlias instance) {
        this(instance,true);
    }

    public HostAliasBuilder(io.fabric8.kubernetes.api.model.HostAlias instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withHostnames(instance.getHostnames()); 
        this.withIp(instance.getIp()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.HostAlias build() {
        HostAlias buildable = new HostAlias(fluent.getHostnames(),fluent.getIp());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        HostAliasBuilder that = (HostAliasBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
