package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PodAffinityBuilder extends io.fabric8.kubernetes.api.model.PodAffinityFluentImpl<io.fabric8.kubernetes.api.model.PodAffinityBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.PodAffinity,io.fabric8.kubernetes.api.model.PodAffinityBuilder> {

    io.fabric8.kubernetes.api.model.PodAffinityFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public PodAffinityBuilder() {
        this(true);
    }

    public PodAffinityBuilder(java.lang.Boolean validationEnabled) {
        this(new PodAffinity(), validationEnabled);
    }

    public PodAffinityBuilder(io.fabric8.kubernetes.api.model.PodAffinityFluent<?> fluent) {
        this(fluent, true);
    }

    public PodAffinityBuilder(io.fabric8.kubernetes.api.model.PodAffinityFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new PodAffinity(), validationEnabled);
    }

    public PodAffinityBuilder(io.fabric8.kubernetes.api.model.PodAffinityFluent<?> fluent,io.fabric8.kubernetes.api.model.PodAffinity instance) {
        this(fluent, instance, true);
    }

    public PodAffinityBuilder(io.fabric8.kubernetes.api.model.PodAffinityFluent<?> fluent,io.fabric8.kubernetes.api.model.PodAffinity instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withPreferredDuringSchedulingIgnoredDuringExecution(instance.getPreferredDuringSchedulingIgnoredDuringExecution()); 
        fluent.withRequiredDuringSchedulingIgnoredDuringExecution(instance.getRequiredDuringSchedulingIgnoredDuringExecution()); 
        this.validationEnabled = validationEnabled; 
    }

    public PodAffinityBuilder(io.fabric8.kubernetes.api.model.PodAffinity instance) {
        this(instance,true);
    }

    public PodAffinityBuilder(io.fabric8.kubernetes.api.model.PodAffinity instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withPreferredDuringSchedulingIgnoredDuringExecution(instance.getPreferredDuringSchedulingIgnoredDuringExecution()); 
        this.withRequiredDuringSchedulingIgnoredDuringExecution(instance.getRequiredDuringSchedulingIgnoredDuringExecution()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.PodAffinity build() {
        PodAffinity buildable = new PodAffinity(fluent.getPreferredDuringSchedulingIgnoredDuringExecution(),fluent.getRequiredDuringSchedulingIgnoredDuringExecution());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PodAffinityBuilder that = (PodAffinityBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
