package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.lang.Boolean;
import java.util.function.Predicate;

public class RootPathsFluentImpl<A extends io.fabric8.kubernetes.api.model.RootPathsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.RootPathsFluent<A> {

    private java.util.List<java.lang.String> paths = new java.util.ArrayList<java.lang.String>();

    public RootPathsFluentImpl() {
    }

    public RootPathsFluentImpl(io.fabric8.kubernetes.api.model.RootPaths instance) {
        this.withPaths(instance.getPaths()); 
    }

    public A addToPaths(int index,java.lang.String item) {
        if (this.paths == null) {this.paths = new java.util.ArrayList<java.lang.String>();}
        this.paths.add(index, item);
        return (A)this;
    }

    public A setToPaths(int index,java.lang.String item) {
        if (this.paths == null) {this.paths = new java.util.ArrayList<java.lang.String>();}
        this.paths.set(index, item); return (A)this;
    }

    public A addToPaths(java.lang.String... items) {
        if (this.paths == null) {this.paths = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.paths.add(item);} return (A)this;
    }

    public A addAllToPaths(java.util.Collection<java.lang.String> items) {
        if (this.paths == null) {this.paths = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.paths.add(item);} return (A)this;
    }

    public A removeFromPaths(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.paths!= null){ this.paths.remove(item);}} return (A)this;
    }

    public A removeAllFromPaths(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.paths!= null){ this.paths.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getPaths() {
        return this.paths;
    }

    public java.lang.String getPath(int index) {
        return this.paths.get(index);
    }

    public java.lang.String getFirstPath() {
        return this.paths.get(0);
    }

    public java.lang.String getLastPath() {
        return this.paths.get(paths.size() - 1);
    }

    public java.lang.String getMatchingPath(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: paths) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingPath(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: paths) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withPaths(java.util.List<java.lang.String> paths) {
        if (this.paths != null) { _visitables.get("paths").removeAll(this.paths);}
        if (paths != null) {this.paths = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : paths){this.addToPaths(item);}} else { this.paths = null;} return (A) this;
    }

    public A withPaths(java.lang.String... paths) {
        if (this.paths != null) {this.paths.clear();}
        if (paths != null) {for (java.lang.String item :paths){ this.addToPaths(item);}} return (A) this;
    }

    public java.lang.Boolean hasPaths() {
        return paths != null && !paths.isEmpty();
    }

    public A addNewPath(java.lang.String arg0) {
        return (A)addToPaths(new String(arg0));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        RootPathsFluentImpl that = (RootPathsFluentImpl) o;
        if (paths != null ? !paths.equals(that.paths) :that.paths != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(paths,  super.hashCode());
    }

}
