package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ServiceBuilder extends io.fabric8.kubernetes.api.model.ServiceFluentImpl<io.fabric8.kubernetes.api.model.ServiceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.Service,io.fabric8.kubernetes.api.model.ServiceBuilder> {

    io.fabric8.kubernetes.api.model.ServiceFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ServiceBuilder() {
        this(true);
    }

    public ServiceBuilder(java.lang.Boolean validationEnabled) {
        this(new Service(), validationEnabled);
    }

    public ServiceBuilder(io.fabric8.kubernetes.api.model.ServiceFluent<?> fluent) {
        this(fluent, true);
    }

    public ServiceBuilder(io.fabric8.kubernetes.api.model.ServiceFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new Service(), validationEnabled);
    }

    public ServiceBuilder(io.fabric8.kubernetes.api.model.ServiceFluent<?> fluent,io.fabric8.kubernetes.api.model.Service instance) {
        this(fluent, instance, true);
    }

    public ServiceBuilder(io.fabric8.kubernetes.api.model.ServiceFluent<?> fluent,io.fabric8.kubernetes.api.model.Service instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public ServiceBuilder(io.fabric8.kubernetes.api.model.Service instance) {
        this(instance,true);
    }

    public ServiceBuilder(io.fabric8.kubernetes.api.model.Service instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.Service build() {
        Service buildable = new Service(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ServiceBuilder that = (ServiceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
