package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SessionAffinityConfigBuilder extends io.fabric8.kubernetes.api.model.SessionAffinityConfigFluentImpl<io.fabric8.kubernetes.api.model.SessionAffinityConfigBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.SessionAffinityConfig,io.fabric8.kubernetes.api.model.SessionAffinityConfigBuilder> {

    io.fabric8.kubernetes.api.model.SessionAffinityConfigFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public SessionAffinityConfigBuilder() {
        this(true);
    }

    public SessionAffinityConfigBuilder(java.lang.Boolean validationEnabled) {
        this(new SessionAffinityConfig(), validationEnabled);
    }

    public SessionAffinityConfigBuilder(io.fabric8.kubernetes.api.model.SessionAffinityConfigFluent<?> fluent) {
        this(fluent, true);
    }

    public SessionAffinityConfigBuilder(io.fabric8.kubernetes.api.model.SessionAffinityConfigFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new SessionAffinityConfig(), validationEnabled);
    }

    public SessionAffinityConfigBuilder(io.fabric8.kubernetes.api.model.SessionAffinityConfigFluent<?> fluent,io.fabric8.kubernetes.api.model.SessionAffinityConfig instance) {
        this(fluent, instance, true);
    }

    public SessionAffinityConfigBuilder(io.fabric8.kubernetes.api.model.SessionAffinityConfigFluent<?> fluent,io.fabric8.kubernetes.api.model.SessionAffinityConfig instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withClientIP(instance.getClientIP()); 
        this.validationEnabled = validationEnabled; 
    }

    public SessionAffinityConfigBuilder(io.fabric8.kubernetes.api.model.SessionAffinityConfig instance) {
        this(instance,true);
    }

    public SessionAffinityConfigBuilder(io.fabric8.kubernetes.api.model.SessionAffinityConfig instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withClientIP(instance.getClientIP()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.SessionAffinityConfig build() {
        SessionAffinityConfig buildable = new SessionAffinityConfig(fluent.getClientIP());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        SessionAffinityConfigBuilder that = (SessionAffinityConfigBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
