package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class TopologySpreadConstraintFluentImpl<A extends io.fabric8.kubernetes.api.model.TopologySpreadConstraintFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.TopologySpreadConstraintFluent<A> {

    private io.fabric8.kubernetes.api.model.LabelSelectorBuilder labelSelector;
    private java.lang.Integer maxSkew;
    private java.lang.String topologyKey;
    private java.lang.String whenUnsatisfiable;

    public TopologySpreadConstraintFluentImpl() {
    }

    public TopologySpreadConstraintFluentImpl(io.fabric8.kubernetes.api.model.TopologySpreadConstraint instance) {
        this.withLabelSelector(instance.getLabelSelector()); 
        this.withMaxSkew(instance.getMaxSkew()); 
        this.withTopologyKey(instance.getTopologyKey()); 
        this.withWhenUnsatisfiable(instance.getWhenUnsatisfiable()); 
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildLabelSelector instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.LabelSelector getLabelSelector() {
        return this.labelSelector!=null?this.labelSelector.build():null;
    }

    public io.fabric8.kubernetes.api.model.LabelSelector buildLabelSelector() {
        return this.labelSelector!=null?this.labelSelector.build():null;
    }

    public A withLabelSelector(io.fabric8.kubernetes.api.model.LabelSelector labelSelector) {
        _visitables.get("labelSelector").remove(this.labelSelector);
        if (labelSelector!=null){ this.labelSelector= new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(labelSelector); _visitables.get("labelSelector").add(this.labelSelector);} return (A) this;
    }

    public java.lang.Boolean hasLabelSelector() {
        return this.labelSelector != null;
    }

    public io.fabric8.kubernetes.api.model.TopologySpreadConstraintFluent.LabelSelectorNested<A> withNewLabelSelector() {
        return new io.fabric8.kubernetes.api.model.TopologySpreadConstraintFluentImpl.LabelSelectorNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.TopologySpreadConstraintFluent.LabelSelectorNested<A> withNewLabelSelectorLike(io.fabric8.kubernetes.api.model.LabelSelector item) {
        return new io.fabric8.kubernetes.api.model.TopologySpreadConstraintFluentImpl.LabelSelectorNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.TopologySpreadConstraintFluent.LabelSelectorNested<A> editLabelSelector() {
        return withNewLabelSelectorLike(getLabelSelector());
    }

    public io.fabric8.kubernetes.api.model.TopologySpreadConstraintFluent.LabelSelectorNested<A> editOrNewLabelSelector() {
        return withNewLabelSelectorLike(getLabelSelector() != null ? getLabelSelector(): new io.fabric8.kubernetes.api.model.LabelSelectorBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.TopologySpreadConstraintFluent.LabelSelectorNested<A> editOrNewLabelSelectorLike(io.fabric8.kubernetes.api.model.LabelSelector item) {
        return withNewLabelSelectorLike(getLabelSelector() != null ? getLabelSelector(): item);
    }

    public java.lang.Integer getMaxSkew() {
        return this.maxSkew;
    }

    public A withMaxSkew(java.lang.Integer maxSkew) {
        this.maxSkew=maxSkew; return (A) this;
    }

    public java.lang.Boolean hasMaxSkew() {
        return this.maxSkew != null;
    }

    public java.lang.String getTopologyKey() {
        return this.topologyKey;
    }

    public A withTopologyKey(java.lang.String topologyKey) {
        this.topologyKey=topologyKey; return (A) this;
    }

    public java.lang.Boolean hasTopologyKey() {
        return this.topologyKey != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withTopologyKey instead.
     */
        public A withNewTopologyKey(java.lang.String arg0) {
        return (A)withTopologyKey(new String(arg0));
    }

    public java.lang.String getWhenUnsatisfiable() {
        return this.whenUnsatisfiable;
    }

    public A withWhenUnsatisfiable(java.lang.String whenUnsatisfiable) {
        this.whenUnsatisfiable=whenUnsatisfiable; return (A) this;
    }

    public java.lang.Boolean hasWhenUnsatisfiable() {
        return this.whenUnsatisfiable != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withWhenUnsatisfiable instead.
     */
        public A withNewWhenUnsatisfiable(java.lang.String arg0) {
        return (A)withWhenUnsatisfiable(new String(arg0));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        TopologySpreadConstraintFluentImpl that = (TopologySpreadConstraintFluentImpl) o;
        if (labelSelector != null ? !labelSelector.equals(that.labelSelector) :that.labelSelector != null) return false;
        if (maxSkew != null ? !maxSkew.equals(that.maxSkew) :that.maxSkew != null) return false;
        if (topologyKey != null ? !topologyKey.equals(that.topologyKey) :that.topologyKey != null) return false;
        if (whenUnsatisfiable != null ? !whenUnsatisfiable.equals(that.whenUnsatisfiable) :that.whenUnsatisfiable != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(labelSelector,  maxSkew,  topologyKey,  whenUnsatisfiable,  super.hashCode());
    }

    public class LabelSelectorNestedImpl<N> extends io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl<io.fabric8.kubernetes.api.model.TopologySpreadConstraintFluent.LabelSelectorNested<N>> implements io.fabric8.kubernetes.api.model.TopologySpreadConstraintFluent.LabelSelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.LabelSelectorBuilder builder;

            LabelSelectorNestedImpl(io.fabric8.kubernetes.api.model.LabelSelector item) {
                this.builder = new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(this, item);
                        
            }

            LabelSelectorNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(this);
                        
            }

            public N and() {
                return (N) TopologySpreadConstraintFluentImpl.this.withLabelSelector(builder.build());
            }

            public N endLabelSelector() {
                return and();
            }
    }


}
