package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class NodeDaemonEndpointsFluentImpl<A extends io.fabric8.kubernetes.api.model.NodeDaemonEndpointsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.NodeDaemonEndpointsFluent<A> {

    private io.fabric8.kubernetes.api.model.DaemonEndpointBuilder kubeletEndpoint;

    public NodeDaemonEndpointsFluentImpl() {
    }

    public NodeDaemonEndpointsFluentImpl(io.fabric8.kubernetes.api.model.NodeDaemonEndpoints instance) {
        this.withKubeletEndpoint(instance.getKubeletEndpoint()); 
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildKubeletEndpoint instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.DaemonEndpoint getKubeletEndpoint() {
        return this.kubeletEndpoint!=null?this.kubeletEndpoint.build():null;
    }

    public io.fabric8.kubernetes.api.model.DaemonEndpoint buildKubeletEndpoint() {
        return this.kubeletEndpoint!=null?this.kubeletEndpoint.build():null;
    }

    public A withKubeletEndpoint(io.fabric8.kubernetes.api.model.DaemonEndpoint kubeletEndpoint) {
        _visitables.get("kubeletEndpoint").remove(this.kubeletEndpoint);
        if (kubeletEndpoint!=null){ this.kubeletEndpoint= new io.fabric8.kubernetes.api.model.DaemonEndpointBuilder(kubeletEndpoint); _visitables.get("kubeletEndpoint").add(this.kubeletEndpoint);} return (A) this;
    }

    public java.lang.Boolean hasKubeletEndpoint() {
        return this.kubeletEndpoint != null;
    }

    public A withNewKubeletEndpoint(java.lang.Integer port) {
        return (A)withKubeletEndpoint(new DaemonEndpoint(port));
    }

    public io.fabric8.kubernetes.api.model.NodeDaemonEndpointsFluent.KubeletEndpointNested<A> withNewKubeletEndpoint() {
        return new io.fabric8.kubernetes.api.model.NodeDaemonEndpointsFluentImpl.KubeletEndpointNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.NodeDaemonEndpointsFluent.KubeletEndpointNested<A> withNewKubeletEndpointLike(io.fabric8.kubernetes.api.model.DaemonEndpoint item) {
        return new io.fabric8.kubernetes.api.model.NodeDaemonEndpointsFluentImpl.KubeletEndpointNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.NodeDaemonEndpointsFluent.KubeletEndpointNested<A> editKubeletEndpoint() {
        return withNewKubeletEndpointLike(getKubeletEndpoint());
    }

    public io.fabric8.kubernetes.api.model.NodeDaemonEndpointsFluent.KubeletEndpointNested<A> editOrNewKubeletEndpoint() {
        return withNewKubeletEndpointLike(getKubeletEndpoint() != null ? getKubeletEndpoint(): new io.fabric8.kubernetes.api.model.DaemonEndpointBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.NodeDaemonEndpointsFluent.KubeletEndpointNested<A> editOrNewKubeletEndpointLike(io.fabric8.kubernetes.api.model.DaemonEndpoint item) {
        return withNewKubeletEndpointLike(getKubeletEndpoint() != null ? getKubeletEndpoint(): item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        NodeDaemonEndpointsFluentImpl that = (NodeDaemonEndpointsFluentImpl) o;
        if (kubeletEndpoint != null ? !kubeletEndpoint.equals(that.kubeletEndpoint) :that.kubeletEndpoint != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(kubeletEndpoint,  super.hashCode());
    }

    public class KubeletEndpointNestedImpl<N> extends io.fabric8.kubernetes.api.model.DaemonEndpointFluentImpl<io.fabric8.kubernetes.api.model.NodeDaemonEndpointsFluent.KubeletEndpointNested<N>> implements io.fabric8.kubernetes.api.model.NodeDaemonEndpointsFluent.KubeletEndpointNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.DaemonEndpointBuilder builder;

            KubeletEndpointNestedImpl(io.fabric8.kubernetes.api.model.DaemonEndpoint item) {
                this.builder = new io.fabric8.kubernetes.api.model.DaemonEndpointBuilder(this, item);
                        
            }

            KubeletEndpointNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.DaemonEndpointBuilder(this);
                        
            }

            public N and() {
                return (N) NodeDaemonEndpointsFluentImpl.this.withKubeletEndpoint(builder.build());
            }

            public N endKubeletEndpoint() {
                return and();
            }
    }


}
