package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;

public class ServiceAccountFluentImpl<A extends io.fabric8.kubernetes.api.model.ServiceAccountFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.ServiceAccountFluent<A> {

    private java.lang.String apiVersion;
    private java.lang.Boolean automountServiceAccountToken;
    private java.util.List<io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder> imagePullSecrets =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder>();
    private java.lang.String kind;
    private io.fabric8.kubernetes.api.model.ObjectMetaBuilder metadata;
    private java.util.List<io.fabric8.kubernetes.api.model.ObjectReferenceBuilder> secrets =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.ObjectReferenceBuilder>();

    public ServiceAccountFluentImpl() {
    }

    public ServiceAccountFluentImpl(io.fabric8.kubernetes.api.model.ServiceAccount instance) {
        this.withApiVersion(instance.getApiVersion()); 
        this.withAutomountServiceAccountToken(instance.getAutomountServiceAccountToken()); 
        this.withImagePullSecrets(instance.getImagePullSecrets()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSecrets(instance.getSecrets()); 
    }

    public java.lang.String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(java.lang.String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public java.lang.Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withApiVersion instead.
     */
        public A withNewApiVersion(java.lang.String arg0) {
        return (A)withApiVersion(new String(arg0));
    }

    public java.lang.Boolean getAutomountServiceAccountToken() {
        return this.automountServiceAccountToken;
    }

    public A withAutomountServiceAccountToken(java.lang.Boolean automountServiceAccountToken) {
        this.automountServiceAccountToken=automountServiceAccountToken; return (A) this;
    }

    public java.lang.Boolean hasAutomountServiceAccountToken() {
        return this.automountServiceAccountToken != null;
    }

    public A addToImagePullSecrets(int index,io.fabric8.kubernetes.api.model.LocalObjectReference item) {
        if (this.imagePullSecrets == null) {this.imagePullSecrets = new java.util.ArrayList<io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder>();}
        io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder builder = new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder(item);_visitables.get("imagePullSecrets").add(index >= 0 ? index : _visitables.get("imagePullSecrets").size(), builder);this.imagePullSecrets.add(index >= 0 ? index : imagePullSecrets.size(), builder); return (A)this;
    }

    public A setToImagePullSecrets(int index,io.fabric8.kubernetes.api.model.LocalObjectReference item) {
        if (this.imagePullSecrets == null) {this.imagePullSecrets = new java.util.ArrayList<io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder>();}
        io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder builder = new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder(item);
        if (index < 0 || index >= _visitables.get("imagePullSecrets").size()) { _visitables.get("imagePullSecrets").add(builder); } else { _visitables.get("imagePullSecrets").set(index, builder);}
        if (index < 0 || index >= imagePullSecrets.size()) { imagePullSecrets.add(builder); } else { imagePullSecrets.set(index, builder);}
         return (A)this;
    }

    public A addToImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... items) {
        if (this.imagePullSecrets == null) {this.imagePullSecrets = new java.util.ArrayList<io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder>();}
        for (io.fabric8.kubernetes.api.model.LocalObjectReference item : items) {io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder builder = new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder(item);_visitables.get("imagePullSecrets").add(builder);this.imagePullSecrets.add(builder);} return (A)this;
    }

    public A addAllToImagePullSecrets(java.util.Collection<io.fabric8.kubernetes.api.model.LocalObjectReference> items) {
        if (this.imagePullSecrets == null) {this.imagePullSecrets = new java.util.ArrayList<io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder>();}
        for (io.fabric8.kubernetes.api.model.LocalObjectReference item : items) {io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder builder = new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder(item);_visitables.get("imagePullSecrets").add(builder);this.imagePullSecrets.add(builder);} return (A)this;
    }

    public A removeFromImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... items) {
        for (io.fabric8.kubernetes.api.model.LocalObjectReference item : items) {io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder builder = new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder(item);_visitables.get("imagePullSecrets").remove(builder);if (this.imagePullSecrets != null) {this.imagePullSecrets.remove(builder);}} return (A)this;
    }

    public A removeAllFromImagePullSecrets(java.util.Collection<io.fabric8.kubernetes.api.model.LocalObjectReference> items) {
        for (io.fabric8.kubernetes.api.model.LocalObjectReference item : items) {io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder builder = new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder(item);_visitables.get("imagePullSecrets").remove(builder);if (this.imagePullSecrets != null) {this.imagePullSecrets.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromImagePullSecrets(java.util.function.Predicate<io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder> predicate) {
        if (imagePullSecrets == null) return (A) this;
        final Iterator<io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder> each = imagePullSecrets.iterator();
        final List visitables = _visitables.get("imagePullSecrets");
        while (each.hasNext()) {
          io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildImagePullSecrets instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.kubernetes.api.model.LocalObjectReference> getImagePullSecrets() {
        return build(imagePullSecrets);
    }

    public java.util.List<io.fabric8.kubernetes.api.model.LocalObjectReference> buildImagePullSecrets() {
        return build(imagePullSecrets);
    }

    public io.fabric8.kubernetes.api.model.LocalObjectReference buildImagePullSecret(int index) {
        return this.imagePullSecrets.get(index).build();
    }

    public io.fabric8.kubernetes.api.model.LocalObjectReference buildFirstImagePullSecret() {
        return this.imagePullSecrets.get(0).build();
    }

    public io.fabric8.kubernetes.api.model.LocalObjectReference buildLastImagePullSecret() {
        return this.imagePullSecrets.get(imagePullSecrets.size() - 1).build();
    }

    public io.fabric8.kubernetes.api.model.LocalObjectReference buildMatchingImagePullSecret(java.util.function.Predicate<io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder> predicate) {
        for (io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder item: imagePullSecrets) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingImagePullSecret(java.util.function.Predicate<io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder> predicate) {
        for (io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder item: imagePullSecrets) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withImagePullSecrets(java.util.List<io.fabric8.kubernetes.api.model.LocalObjectReference> imagePullSecrets) {
        if (this.imagePullSecrets != null) { _visitables.get("imagePullSecrets").removeAll(this.imagePullSecrets);}
        if (imagePullSecrets != null) {this.imagePullSecrets = new java.util.ArrayList<io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder>(); for (io.fabric8.kubernetes.api.model.LocalObjectReference item : imagePullSecrets){this.addToImagePullSecrets(item);}} else { this.imagePullSecrets = null;} return (A) this;
    }

    public A withImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... imagePullSecrets) {
        if (this.imagePullSecrets != null) {this.imagePullSecrets.clear();}
        if (imagePullSecrets != null) {for (io.fabric8.kubernetes.api.model.LocalObjectReference item :imagePullSecrets){ this.addToImagePullSecrets(item);}} return (A) this;
    }

    public java.lang.Boolean hasImagePullSecrets() {
        return imagePullSecrets != null && !imagePullSecrets.isEmpty();
    }

    public A addNewImagePullSecret(java.lang.String name) {
        return (A)addToImagePullSecrets(new LocalObjectReference(name));
    }

    public io.fabric8.kubernetes.api.model.ServiceAccountFluent.ImagePullSecretsNested<A> addNewImagePullSecret() {
        return new io.fabric8.kubernetes.api.model.ServiceAccountFluentImpl.ImagePullSecretsNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.ServiceAccountFluent.ImagePullSecretsNested<A> addNewImagePullSecretLike(io.fabric8.kubernetes.api.model.LocalObjectReference item) {
        return new io.fabric8.kubernetes.api.model.ServiceAccountFluentImpl.ImagePullSecretsNestedImpl(-1, item);
    }

    public io.fabric8.kubernetes.api.model.ServiceAccountFluent.ImagePullSecretsNested<A> setNewImagePullSecretLike(int index,io.fabric8.kubernetes.api.model.LocalObjectReference item) {
        return new io.fabric8.kubernetes.api.model.ServiceAccountFluentImpl.ImagePullSecretsNestedImpl(index, item);
    }

    public io.fabric8.kubernetes.api.model.ServiceAccountFluent.ImagePullSecretsNested<A> editImagePullSecret(int index) {
        if (imagePullSecrets.size() <= index) throw new RuntimeException("Can't edit imagePullSecrets. Index exceeds size.");
        return setNewImagePullSecretLike(index, buildImagePullSecret(index));
    }

    public io.fabric8.kubernetes.api.model.ServiceAccountFluent.ImagePullSecretsNested<A> editFirstImagePullSecret() {
        if (imagePullSecrets.size() == 0) throw new RuntimeException("Can't edit first imagePullSecrets. The list is empty.");
        return setNewImagePullSecretLike(0, buildImagePullSecret(0));
    }

    public io.fabric8.kubernetes.api.model.ServiceAccountFluent.ImagePullSecretsNested<A> editLastImagePullSecret() {
        int index = imagePullSecrets.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last imagePullSecrets. The list is empty.");
        return setNewImagePullSecretLike(index, buildImagePullSecret(index));
    }

    public io.fabric8.kubernetes.api.model.ServiceAccountFluent.ImagePullSecretsNested<A> editMatchingImagePullSecret(java.util.function.Predicate<io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder> predicate) {
        int index = -1;
        for (int i=0;i<imagePullSecrets.size();i++) { 
        if (predicate.test(imagePullSecrets.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching imagePullSecrets. No match found.");
        return setNewImagePullSecretLike(index, buildImagePullSecret(index));
    }

    public java.lang.String getKind() {
        return this.kind;
    }

    public A withKind(java.lang.String kind) {
        this.kind=kind; return (A) this;
    }

    public java.lang.Boolean hasKind() {
        return this.kind != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withKind instead.
     */
        public A withNewKind(java.lang.String arg0) {
        return (A)withKind(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildMetadata instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.ObjectMeta getMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public io.fabric8.kubernetes.api.model.ObjectMeta buildMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
        _visitables.get("metadata").remove(this.metadata);
        if (metadata!=null){ this.metadata= new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public java.lang.Boolean hasMetadata() {
        return this.metadata != null;
    }

    public io.fabric8.kubernetes.api.model.ServiceAccountFluent.MetadataNested<A> withNewMetadata() {
        return new io.fabric8.kubernetes.api.model.ServiceAccountFluentImpl.MetadataNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.ServiceAccountFluent.MetadataNested<A> withNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
        return new io.fabric8.kubernetes.api.model.ServiceAccountFluentImpl.MetadataNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.ServiceAccountFluent.MetadataNested<A> editMetadata() {
        return withNewMetadataLike(getMetadata());
    }

    public io.fabric8.kubernetes.api.model.ServiceAccountFluent.MetadataNested<A> editOrNewMetadata() {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): new io.fabric8.kubernetes.api.model.ObjectMetaBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.ServiceAccountFluent.MetadataNested<A> editOrNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public A addToSecrets(int index,io.fabric8.kubernetes.api.model.ObjectReference item) {
        if (this.secrets == null) {this.secrets = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ObjectReferenceBuilder>();}
        io.fabric8.kubernetes.api.model.ObjectReferenceBuilder builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(item);_visitables.get("secrets").add(index >= 0 ? index : _visitables.get("secrets").size(), builder);this.secrets.add(index >= 0 ? index : secrets.size(), builder); return (A)this;
    }

    public A setToSecrets(int index,io.fabric8.kubernetes.api.model.ObjectReference item) {
        if (this.secrets == null) {this.secrets = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ObjectReferenceBuilder>();}
        io.fabric8.kubernetes.api.model.ObjectReferenceBuilder builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(item);
        if (index < 0 || index >= _visitables.get("secrets").size()) { _visitables.get("secrets").add(builder); } else { _visitables.get("secrets").set(index, builder);}
        if (index < 0 || index >= secrets.size()) { secrets.add(builder); } else { secrets.set(index, builder);}
         return (A)this;
    }

    public A addToSecrets(io.fabric8.kubernetes.api.model.ObjectReference... items) {
        if (this.secrets == null) {this.secrets = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ObjectReferenceBuilder>();}
        for (io.fabric8.kubernetes.api.model.ObjectReference item : items) {io.fabric8.kubernetes.api.model.ObjectReferenceBuilder builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(item);_visitables.get("secrets").add(builder);this.secrets.add(builder);} return (A)this;
    }

    public A addAllToSecrets(java.util.Collection<io.fabric8.kubernetes.api.model.ObjectReference> items) {
        if (this.secrets == null) {this.secrets = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ObjectReferenceBuilder>();}
        for (io.fabric8.kubernetes.api.model.ObjectReference item : items) {io.fabric8.kubernetes.api.model.ObjectReferenceBuilder builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(item);_visitables.get("secrets").add(builder);this.secrets.add(builder);} return (A)this;
    }

    public A removeFromSecrets(io.fabric8.kubernetes.api.model.ObjectReference... items) {
        for (io.fabric8.kubernetes.api.model.ObjectReference item : items) {io.fabric8.kubernetes.api.model.ObjectReferenceBuilder builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(item);_visitables.get("secrets").remove(builder);if (this.secrets != null) {this.secrets.remove(builder);}} return (A)this;
    }

    public A removeAllFromSecrets(java.util.Collection<io.fabric8.kubernetes.api.model.ObjectReference> items) {
        for (io.fabric8.kubernetes.api.model.ObjectReference item : items) {io.fabric8.kubernetes.api.model.ObjectReferenceBuilder builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(item);_visitables.get("secrets").remove(builder);if (this.secrets != null) {this.secrets.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromSecrets(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ObjectReferenceBuilder> predicate) {
        if (secrets == null) return (A) this;
        final Iterator<io.fabric8.kubernetes.api.model.ObjectReferenceBuilder> each = secrets.iterator();
        final List visitables = _visitables.get("secrets");
        while (each.hasNext()) {
          io.fabric8.kubernetes.api.model.ObjectReferenceBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildSecrets instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.kubernetes.api.model.ObjectReference> getSecrets() {
        return build(secrets);
    }

    public java.util.List<io.fabric8.kubernetes.api.model.ObjectReference> buildSecrets() {
        return build(secrets);
    }

    public io.fabric8.kubernetes.api.model.ObjectReference buildSecret(int index) {
        return this.secrets.get(index).build();
    }

    public io.fabric8.kubernetes.api.model.ObjectReference buildFirstSecret() {
        return this.secrets.get(0).build();
    }

    public io.fabric8.kubernetes.api.model.ObjectReference buildLastSecret() {
        return this.secrets.get(secrets.size() - 1).build();
    }

    public io.fabric8.kubernetes.api.model.ObjectReference buildMatchingSecret(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ObjectReferenceBuilder> predicate) {
        for (io.fabric8.kubernetes.api.model.ObjectReferenceBuilder item: secrets) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingSecret(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ObjectReferenceBuilder> predicate) {
        for (io.fabric8.kubernetes.api.model.ObjectReferenceBuilder item: secrets) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withSecrets(java.util.List<io.fabric8.kubernetes.api.model.ObjectReference> secrets) {
        if (this.secrets != null) { _visitables.get("secrets").removeAll(this.secrets);}
        if (secrets != null) {this.secrets = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ObjectReferenceBuilder>(); for (io.fabric8.kubernetes.api.model.ObjectReference item : secrets){this.addToSecrets(item);}} else { this.secrets = null;} return (A) this;
    }

    public A withSecrets(io.fabric8.kubernetes.api.model.ObjectReference... secrets) {
        if (this.secrets != null) {this.secrets.clear();}
        if (secrets != null) {for (io.fabric8.kubernetes.api.model.ObjectReference item :secrets){ this.addToSecrets(item);}} return (A) this;
    }

    public java.lang.Boolean hasSecrets() {
        return secrets != null && !secrets.isEmpty();
    }

    public io.fabric8.kubernetes.api.model.ServiceAccountFluent.SecretsNested<A> addNewSecret() {
        return new io.fabric8.kubernetes.api.model.ServiceAccountFluentImpl.SecretsNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.ServiceAccountFluent.SecretsNested<A> addNewSecretLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
        return new io.fabric8.kubernetes.api.model.ServiceAccountFluentImpl.SecretsNestedImpl(-1, item);
    }

    public io.fabric8.kubernetes.api.model.ServiceAccountFluent.SecretsNested<A> setNewSecretLike(int index,io.fabric8.kubernetes.api.model.ObjectReference item) {
        return new io.fabric8.kubernetes.api.model.ServiceAccountFluentImpl.SecretsNestedImpl(index, item);
    }

    public io.fabric8.kubernetes.api.model.ServiceAccountFluent.SecretsNested<A> editSecret(int index) {
        if (secrets.size() <= index) throw new RuntimeException("Can't edit secrets. Index exceeds size.");
        return setNewSecretLike(index, buildSecret(index));
    }

    public io.fabric8.kubernetes.api.model.ServiceAccountFluent.SecretsNested<A> editFirstSecret() {
        if (secrets.size() == 0) throw new RuntimeException("Can't edit first secrets. The list is empty.");
        return setNewSecretLike(0, buildSecret(0));
    }

    public io.fabric8.kubernetes.api.model.ServiceAccountFluent.SecretsNested<A> editLastSecret() {
        int index = secrets.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last secrets. The list is empty.");
        return setNewSecretLike(index, buildSecret(index));
    }

    public io.fabric8.kubernetes.api.model.ServiceAccountFluent.SecretsNested<A> editMatchingSecret(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ObjectReferenceBuilder> predicate) {
        int index = -1;
        for (int i=0;i<secrets.size();i++) { 
        if (predicate.test(secrets.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching secrets. No match found.");
        return setNewSecretLike(index, buildSecret(index));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ServiceAccountFluentImpl that = (ServiceAccountFluentImpl) o;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (automountServiceAccountToken != null ? !automountServiceAccountToken.equals(that.automountServiceAccountToken) :that.automountServiceAccountToken != null) return false;
        if (imagePullSecrets != null ? !imagePullSecrets.equals(that.imagePullSecrets) :that.imagePullSecrets != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
        if (secrets != null ? !secrets.equals(that.secrets) :that.secrets != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiVersion,  automountServiceAccountToken,  imagePullSecrets,  kind,  metadata,  secrets,  super.hashCode());
    }

    public class ImagePullSecretsNestedImpl<N> extends io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl<io.fabric8.kubernetes.api.model.ServiceAccountFluent.ImagePullSecretsNested<N>> implements io.fabric8.kubernetes.api.model.ServiceAccountFluent.ImagePullSecretsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder builder;
        private final int index;

            ImagePullSecretsNestedImpl(int index,io.fabric8.kubernetes.api.model.LocalObjectReference item) {
                this.index = index;
                this.builder = new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder(this, item);
                        
            }

            ImagePullSecretsNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) ServiceAccountFluentImpl.this.setToImagePullSecrets(index,builder.build());
            }

            public N endImagePullSecret() {
                return and();
            }
    }


    public class MetadataNestedImpl<N> extends io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl<io.fabric8.kubernetes.api.model.ServiceAccountFluent.MetadataNested<N>> implements io.fabric8.kubernetes.api.model.ServiceAccountFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.ObjectMetaBuilder builder;

            MetadataNestedImpl(io.fabric8.kubernetes.api.model.ObjectMeta item) {
                this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this, item);
                        
            }

            MetadataNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this);
                        
            }

            public N and() {
                return (N) ServiceAccountFluentImpl.this.withMetadata(builder.build());
            }

            public N endMetadata() {
                return and();
            }
    }


    public class SecretsNestedImpl<N> extends io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl<io.fabric8.kubernetes.api.model.ServiceAccountFluent.SecretsNested<N>> implements io.fabric8.kubernetes.api.model.ServiceAccountFluent.SecretsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.ObjectReferenceBuilder builder;
        private final int index;

            SecretsNestedImpl(int index,io.fabric8.kubernetes.api.model.ObjectReference item) {
                this.index = index;
                this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this, item);
                        
            }

            SecretsNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) ServiceAccountFluentImpl.this.setToSecrets(index,builder.build());
            }

            public N endSecret() {
                return and();
            }
    }


}
