package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ServiceReferenceBuilder extends io.fabric8.kubernetes.api.model.ServiceReferenceFluentImpl<io.fabric8.kubernetes.api.model.ServiceReferenceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.ServiceReference,io.fabric8.kubernetes.api.model.ServiceReferenceBuilder> {

    io.fabric8.kubernetes.api.model.ServiceReferenceFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ServiceReferenceBuilder() {
        this(true);
    }

    public ServiceReferenceBuilder(java.lang.Boolean validationEnabled) {
        this(new ServiceReference(), validationEnabled);
    }

    public ServiceReferenceBuilder(io.fabric8.kubernetes.api.model.ServiceReferenceFluent<?> fluent) {
        this(fluent, true);
    }

    public ServiceReferenceBuilder(io.fabric8.kubernetes.api.model.ServiceReferenceFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ServiceReference(), validationEnabled);
    }

    public ServiceReferenceBuilder(io.fabric8.kubernetes.api.model.ServiceReferenceFluent<?> fluent,io.fabric8.kubernetes.api.model.ServiceReference instance) {
        this(fluent, instance, true);
    }

    public ServiceReferenceBuilder(io.fabric8.kubernetes.api.model.ServiceReferenceFluent<?> fluent,io.fabric8.kubernetes.api.model.ServiceReference instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withName(instance.getName()); 
        fluent.withNamespace(instance.getNamespace()); 
        fluent.withPort(instance.getPort()); 
        this.validationEnabled = validationEnabled; 
    }

    public ServiceReferenceBuilder(io.fabric8.kubernetes.api.model.ServiceReference instance) {
        this(instance,true);
    }

    public ServiceReferenceBuilder(io.fabric8.kubernetes.api.model.ServiceReference instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withName(instance.getName()); 
        this.withNamespace(instance.getNamespace()); 
        this.withPort(instance.getPort()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.ServiceReference build() {
        ServiceReference buildable = new ServiceReference(fluent.getName(),fluent.getNamespace(),fluent.getPort());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ServiceReferenceBuilder that = (ServiceReferenceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
