package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TypeMetaBuilder extends io.fabric8.kubernetes.api.model.TypeMetaFluentImpl<io.fabric8.kubernetes.api.model.TypeMetaBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.TypeMeta,io.fabric8.kubernetes.api.model.TypeMetaBuilder> {

    io.fabric8.kubernetes.api.model.TypeMetaFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public TypeMetaBuilder() {
        this(true);
    }

    public TypeMetaBuilder(java.lang.Boolean validationEnabled) {
        this(new TypeMeta(), validationEnabled);
    }

    public TypeMetaBuilder(io.fabric8.kubernetes.api.model.TypeMetaFluent<?> fluent) {
        this(fluent, true);
    }

    public TypeMetaBuilder(io.fabric8.kubernetes.api.model.TypeMetaFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new TypeMeta(), validationEnabled);
    }

    public TypeMetaBuilder(io.fabric8.kubernetes.api.model.TypeMetaFluent<?> fluent,io.fabric8.kubernetes.api.model.TypeMeta instance) {
        this(fluent, instance, true);
    }

    public TypeMetaBuilder(io.fabric8.kubernetes.api.model.TypeMetaFluent<?> fluent,io.fabric8.kubernetes.api.model.TypeMeta instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        this.validationEnabled = validationEnabled; 
    }

    public TypeMetaBuilder(io.fabric8.kubernetes.api.model.TypeMeta instance) {
        this(instance,true);
    }

    public TypeMetaBuilder(io.fabric8.kubernetes.api.model.TypeMeta instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.TypeMeta build() {
        TypeMeta buildable = new TypeMeta(fluent.getApiVersion(),fluent.getKind());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        TypeMetaBuilder that = (TypeMetaBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
