package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ConfigMapVolumeSourceBuilder extends io.fabric8.kubernetes.api.model.ConfigMapVolumeSourceFluentImpl<io.fabric8.kubernetes.api.model.ConfigMapVolumeSourceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.ConfigMapVolumeSource,io.fabric8.kubernetes.api.model.ConfigMapVolumeSourceBuilder> {

    io.fabric8.kubernetes.api.model.ConfigMapVolumeSourceFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ConfigMapVolumeSourceBuilder() {
        this(true);
    }

    public ConfigMapVolumeSourceBuilder(java.lang.Boolean validationEnabled) {
        this(new ConfigMapVolumeSource(), validationEnabled);
    }

    public ConfigMapVolumeSourceBuilder(io.fabric8.kubernetes.api.model.ConfigMapVolumeSourceFluent<?> fluent) {
        this(fluent, true);
    }

    public ConfigMapVolumeSourceBuilder(io.fabric8.kubernetes.api.model.ConfigMapVolumeSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ConfigMapVolumeSource(), validationEnabled);
    }

    public ConfigMapVolumeSourceBuilder(io.fabric8.kubernetes.api.model.ConfigMapVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.ConfigMapVolumeSource instance) {
        this(fluent, instance, true);
    }

    public ConfigMapVolumeSourceBuilder(io.fabric8.kubernetes.api.model.ConfigMapVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.ConfigMapVolumeSource instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withDefaultMode(instance.getDefaultMode()); 
        fluent.withItems(instance.getItems()); 
        fluent.withName(instance.getName()); 
        fluent.withOptional(instance.getOptional()); 
        this.validationEnabled = validationEnabled; 
    }

    public ConfigMapVolumeSourceBuilder(io.fabric8.kubernetes.api.model.ConfigMapVolumeSource instance) {
        this(instance,true);
    }

    public ConfigMapVolumeSourceBuilder(io.fabric8.kubernetes.api.model.ConfigMapVolumeSource instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withDefaultMode(instance.getDefaultMode()); 
        this.withItems(instance.getItems()); 
        this.withName(instance.getName()); 
        this.withOptional(instance.getOptional()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.ConfigMapVolumeSource build() {
        ConfigMapVolumeSource buildable = new ConfigMapVolumeSource(fluent.getDefaultMode(),fluent.getItems(),fluent.getName(),fluent.getOptional());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ConfigMapVolumeSourceBuilder that = (ConfigMapVolumeSourceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
