package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ISCSIVolumeSourceBuilder extends io.fabric8.kubernetes.api.model.ISCSIVolumeSourceFluentImpl<io.fabric8.kubernetes.api.model.ISCSIVolumeSourceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.ISCSIVolumeSource,io.fabric8.kubernetes.api.model.ISCSIVolumeSourceBuilder> {

    io.fabric8.kubernetes.api.model.ISCSIVolumeSourceFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ISCSIVolumeSourceBuilder() {
        this(true);
    }

    public ISCSIVolumeSourceBuilder(java.lang.Boolean validationEnabled) {
        this(new ISCSIVolumeSource(), validationEnabled);
    }

    public ISCSIVolumeSourceBuilder(io.fabric8.kubernetes.api.model.ISCSIVolumeSourceFluent<?> fluent) {
        this(fluent, true);
    }

    public ISCSIVolumeSourceBuilder(io.fabric8.kubernetes.api.model.ISCSIVolumeSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ISCSIVolumeSource(), validationEnabled);
    }

    public ISCSIVolumeSourceBuilder(io.fabric8.kubernetes.api.model.ISCSIVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.ISCSIVolumeSource instance) {
        this(fluent, instance, true);
    }

    public ISCSIVolumeSourceBuilder(io.fabric8.kubernetes.api.model.ISCSIVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.ISCSIVolumeSource instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withChapAuthDiscovery(instance.getChapAuthDiscovery()); 
        fluent.withChapAuthSession(instance.getChapAuthSession()); 
        fluent.withFsType(instance.getFsType()); 
        fluent.withInitiatorName(instance.getInitiatorName()); 
        fluent.withIqn(instance.getIqn()); 
        fluent.withIscsiInterface(instance.getIscsiInterface()); 
        fluent.withLun(instance.getLun()); 
        fluent.withPortals(instance.getPortals()); 
        fluent.withReadOnly(instance.getReadOnly()); 
        fluent.withSecretRef(instance.getSecretRef()); 
        fluent.withTargetPortal(instance.getTargetPortal()); 
        this.validationEnabled = validationEnabled; 
    }

    public ISCSIVolumeSourceBuilder(io.fabric8.kubernetes.api.model.ISCSIVolumeSource instance) {
        this(instance,true);
    }

    public ISCSIVolumeSourceBuilder(io.fabric8.kubernetes.api.model.ISCSIVolumeSource instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withChapAuthDiscovery(instance.getChapAuthDiscovery()); 
        this.withChapAuthSession(instance.getChapAuthSession()); 
        this.withFsType(instance.getFsType()); 
        this.withInitiatorName(instance.getInitiatorName()); 
        this.withIqn(instance.getIqn()); 
        this.withIscsiInterface(instance.getIscsiInterface()); 
        this.withLun(instance.getLun()); 
        this.withPortals(instance.getPortals()); 
        this.withReadOnly(instance.getReadOnly()); 
        this.withSecretRef(instance.getSecretRef()); 
        this.withTargetPortal(instance.getTargetPortal()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.ISCSIVolumeSource build() {
        ISCSIVolumeSource buildable = new ISCSIVolumeSource(fluent.getChapAuthDiscovery(),fluent.getChapAuthSession(),fluent.getFsType(),fluent.getInitiatorName(),fluent.getIqn(),fluent.getIscsiInterface(),fluent.getLun(),fluent.getPortals(),fluent.getReadOnly(),fluent.getSecretRef(),fluent.getTargetPortal());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ISCSIVolumeSourceBuilder that = (ISCSIVolumeSourceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
