package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;

public class PodSecurityContextFluentImpl<A extends io.fabric8.kubernetes.api.model.PodSecurityContextFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.PodSecurityContextFluent<A> {

    private java.lang.Long fsGroup;
    private java.lang.String fsGroupChangePolicy;
    private java.lang.Long runAsGroup;
    private java.lang.Boolean runAsNonRoot;
    private java.lang.Long runAsUser;
    private io.fabric8.kubernetes.api.model.SELinuxOptionsBuilder seLinuxOptions;
    private io.fabric8.kubernetes.api.model.SeccompProfileBuilder seccompProfile;
    private java.util.List<java.lang.Long> supplementalGroups = new java.util.ArrayList<java.lang.Long>();
    private java.util.List<io.fabric8.kubernetes.api.model.SysctlBuilder> sysctls =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.SysctlBuilder>();
    private io.fabric8.kubernetes.api.model.WindowsSecurityContextOptionsBuilder windowsOptions;

    public PodSecurityContextFluentImpl() {
    }

    public PodSecurityContextFluentImpl(io.fabric8.kubernetes.api.model.PodSecurityContext instance) {
        this.withFsGroup(instance.getFsGroup()); 
        this.withFsGroupChangePolicy(instance.getFsGroupChangePolicy()); 
        this.withRunAsGroup(instance.getRunAsGroup()); 
        this.withRunAsNonRoot(instance.getRunAsNonRoot()); 
        this.withRunAsUser(instance.getRunAsUser()); 
        this.withSeLinuxOptions(instance.getSeLinuxOptions()); 
        this.withSeccompProfile(instance.getSeccompProfile()); 
        this.withSupplementalGroups(instance.getSupplementalGroups()); 
        this.withSysctls(instance.getSysctls()); 
        this.withWindowsOptions(instance.getWindowsOptions()); 
    }

    public java.lang.Long getFsGroup() {
        return this.fsGroup;
    }

    public A withFsGroup(java.lang.Long fsGroup) {
        this.fsGroup=fsGroup; return (A) this;
    }

    public java.lang.Boolean hasFsGroup() {
        return this.fsGroup != null;
    }

    public java.lang.String getFsGroupChangePolicy() {
        return this.fsGroupChangePolicy;
    }

    public A withFsGroupChangePolicy(java.lang.String fsGroupChangePolicy) {
        this.fsGroupChangePolicy=fsGroupChangePolicy; return (A) this;
    }

    public java.lang.Boolean hasFsGroupChangePolicy() {
        return this.fsGroupChangePolicy != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withFsGroupChangePolicy instead.
     */
        public A withNewFsGroupChangePolicy(java.lang.String arg0) {
        return (A)withFsGroupChangePolicy(new String(arg0));
    }

    public java.lang.Long getRunAsGroup() {
        return this.runAsGroup;
    }

    public A withRunAsGroup(java.lang.Long runAsGroup) {
        this.runAsGroup=runAsGroup; return (A) this;
    }

    public java.lang.Boolean hasRunAsGroup() {
        return this.runAsGroup != null;
    }

    public java.lang.Boolean getRunAsNonRoot() {
        return this.runAsNonRoot;
    }

    public A withRunAsNonRoot(java.lang.Boolean runAsNonRoot) {
        this.runAsNonRoot=runAsNonRoot; return (A) this;
    }

    public java.lang.Boolean hasRunAsNonRoot() {
        return this.runAsNonRoot != null;
    }

    public java.lang.Long getRunAsUser() {
        return this.runAsUser;
    }

    public A withRunAsUser(java.lang.Long runAsUser) {
        this.runAsUser=runAsUser; return (A) this;
    }

    public java.lang.Boolean hasRunAsUser() {
        return this.runAsUser != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildSeLinuxOptions instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.SELinuxOptions getSeLinuxOptions() {
        return this.seLinuxOptions!=null?this.seLinuxOptions.build():null;
    }

    public io.fabric8.kubernetes.api.model.SELinuxOptions buildSeLinuxOptions() {
        return this.seLinuxOptions!=null?this.seLinuxOptions.build():null;
    }

    public A withSeLinuxOptions(io.fabric8.kubernetes.api.model.SELinuxOptions seLinuxOptions) {
        _visitables.get("seLinuxOptions").remove(this.seLinuxOptions);
        if (seLinuxOptions!=null){ this.seLinuxOptions= new io.fabric8.kubernetes.api.model.SELinuxOptionsBuilder(seLinuxOptions); _visitables.get("seLinuxOptions").add(this.seLinuxOptions);} return (A) this;
    }

    public java.lang.Boolean hasSeLinuxOptions() {
        return this.seLinuxOptions != null;
    }

    public A withNewSeLinuxOptions(java.lang.String level,java.lang.String role,java.lang.String type,java.lang.String user) {
        return (A)withSeLinuxOptions(new SELinuxOptions(level, role, type, user));
    }

    public io.fabric8.kubernetes.api.model.PodSecurityContextFluent.SeLinuxOptionsNested<A> withNewSeLinuxOptions() {
        return new io.fabric8.kubernetes.api.model.PodSecurityContextFluentImpl.SeLinuxOptionsNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.PodSecurityContextFluent.SeLinuxOptionsNested<A> withNewSeLinuxOptionsLike(io.fabric8.kubernetes.api.model.SELinuxOptions item) {
        return new io.fabric8.kubernetes.api.model.PodSecurityContextFluentImpl.SeLinuxOptionsNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.PodSecurityContextFluent.SeLinuxOptionsNested<A> editSeLinuxOptions() {
        return withNewSeLinuxOptionsLike(getSeLinuxOptions());
    }

    public io.fabric8.kubernetes.api.model.PodSecurityContextFluent.SeLinuxOptionsNested<A> editOrNewSeLinuxOptions() {
        return withNewSeLinuxOptionsLike(getSeLinuxOptions() != null ? getSeLinuxOptions(): new io.fabric8.kubernetes.api.model.SELinuxOptionsBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.PodSecurityContextFluent.SeLinuxOptionsNested<A> editOrNewSeLinuxOptionsLike(io.fabric8.kubernetes.api.model.SELinuxOptions item) {
        return withNewSeLinuxOptionsLike(getSeLinuxOptions() != null ? getSeLinuxOptions(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildSeccompProfile instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.SeccompProfile getSeccompProfile() {
        return this.seccompProfile!=null?this.seccompProfile.build():null;
    }

    public io.fabric8.kubernetes.api.model.SeccompProfile buildSeccompProfile() {
        return this.seccompProfile!=null?this.seccompProfile.build():null;
    }

    public A withSeccompProfile(io.fabric8.kubernetes.api.model.SeccompProfile seccompProfile) {
        _visitables.get("seccompProfile").remove(this.seccompProfile);
        if (seccompProfile!=null){ this.seccompProfile= new io.fabric8.kubernetes.api.model.SeccompProfileBuilder(seccompProfile); _visitables.get("seccompProfile").add(this.seccompProfile);} return (A) this;
    }

    public java.lang.Boolean hasSeccompProfile() {
        return this.seccompProfile != null;
    }

    public A withNewSeccompProfile(java.lang.String localhostProfile,java.lang.String type) {
        return (A)withSeccompProfile(new SeccompProfile(localhostProfile, type));
    }

    public io.fabric8.kubernetes.api.model.PodSecurityContextFluent.SeccompProfileNested<A> withNewSeccompProfile() {
        return new io.fabric8.kubernetes.api.model.PodSecurityContextFluentImpl.SeccompProfileNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.PodSecurityContextFluent.SeccompProfileNested<A> withNewSeccompProfileLike(io.fabric8.kubernetes.api.model.SeccompProfile item) {
        return new io.fabric8.kubernetes.api.model.PodSecurityContextFluentImpl.SeccompProfileNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.PodSecurityContextFluent.SeccompProfileNested<A> editSeccompProfile() {
        return withNewSeccompProfileLike(getSeccompProfile());
    }

    public io.fabric8.kubernetes.api.model.PodSecurityContextFluent.SeccompProfileNested<A> editOrNewSeccompProfile() {
        return withNewSeccompProfileLike(getSeccompProfile() != null ? getSeccompProfile(): new io.fabric8.kubernetes.api.model.SeccompProfileBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.PodSecurityContextFluent.SeccompProfileNested<A> editOrNewSeccompProfileLike(io.fabric8.kubernetes.api.model.SeccompProfile item) {
        return withNewSeccompProfileLike(getSeccompProfile() != null ? getSeccompProfile(): item);
    }

    public A addToSupplementalGroups(int index,java.lang.Long item) {
        if (this.supplementalGroups == null) {this.supplementalGroups = new java.util.ArrayList<java.lang.Long>();}
        this.supplementalGroups.add(index, item);
        return (A)this;
    }

    public A setToSupplementalGroups(int index,java.lang.Long item) {
        if (this.supplementalGroups == null) {this.supplementalGroups = new java.util.ArrayList<java.lang.Long>();}
        this.supplementalGroups.set(index, item); return (A)this;
    }

    public A addToSupplementalGroups(java.lang.Long... items) {
        if (this.supplementalGroups == null) {this.supplementalGroups = new java.util.ArrayList<java.lang.Long>();}
        for (java.lang.Long item : items) {this.supplementalGroups.add(item);} return (A)this;
    }

    public A addAllToSupplementalGroups(java.util.Collection<java.lang.Long> items) {
        if (this.supplementalGroups == null) {this.supplementalGroups = new java.util.ArrayList<java.lang.Long>();}
        for (java.lang.Long item : items) {this.supplementalGroups.add(item);} return (A)this;
    }

    public A removeFromSupplementalGroups(java.lang.Long... items) {
        for (java.lang.Long item : items) {if (this.supplementalGroups!= null){ this.supplementalGroups.remove(item);}} return (A)this;
    }

    public A removeAllFromSupplementalGroups(java.util.Collection<java.lang.Long> items) {
        for (java.lang.Long item : items) {if (this.supplementalGroups!= null){ this.supplementalGroups.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.Long> getSupplementalGroups() {
        return this.supplementalGroups;
    }

    public java.lang.Long getSupplementalGroup(int index) {
        return this.supplementalGroups.get(index);
    }

    public java.lang.Long getFirstSupplementalGroup() {
        return this.supplementalGroups.get(0);
    }

    public java.lang.Long getLastSupplementalGroup() {
        return this.supplementalGroups.get(supplementalGroups.size() - 1);
    }

    public java.lang.Long getMatchingSupplementalGroup(java.util.function.Predicate<java.lang.Long> predicate) {
        for (java.lang.Long item: supplementalGroups) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingSupplementalGroup(java.util.function.Predicate<java.lang.Long> predicate) {
        for (java.lang.Long item: supplementalGroups) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withSupplementalGroups(java.util.List<java.lang.Long> supplementalGroups) {
        if (this.supplementalGroups != null) { _visitables.get("supplementalGroups").removeAll(this.supplementalGroups);}
        if (supplementalGroups != null) {this.supplementalGroups = new java.util.ArrayList<java.lang.Long>(); for (java.lang.Long item : supplementalGroups){this.addToSupplementalGroups(item);}} else { this.supplementalGroups = null;} return (A) this;
    }

    public A withSupplementalGroups(java.lang.Long... supplementalGroups) {
        if (this.supplementalGroups != null) {this.supplementalGroups.clear();}
        if (supplementalGroups != null) {for (java.lang.Long item :supplementalGroups){ this.addToSupplementalGroups(item);}} return (A) this;
    }

    public java.lang.Boolean hasSupplementalGroups() {
        return supplementalGroups != null && !supplementalGroups.isEmpty();
    }

    public A addToSysctls(int index,io.fabric8.kubernetes.api.model.Sysctl item) {
        if (this.sysctls == null) {this.sysctls = new java.util.ArrayList<io.fabric8.kubernetes.api.model.SysctlBuilder>();}
        io.fabric8.kubernetes.api.model.SysctlBuilder builder = new io.fabric8.kubernetes.api.model.SysctlBuilder(item);_visitables.get("sysctls").add(index >= 0 ? index : _visitables.get("sysctls").size(), builder);this.sysctls.add(index >= 0 ? index : sysctls.size(), builder); return (A)this;
    }

    public A setToSysctls(int index,io.fabric8.kubernetes.api.model.Sysctl item) {
        if (this.sysctls == null) {this.sysctls = new java.util.ArrayList<io.fabric8.kubernetes.api.model.SysctlBuilder>();}
        io.fabric8.kubernetes.api.model.SysctlBuilder builder = new io.fabric8.kubernetes.api.model.SysctlBuilder(item);
        if (index < 0 || index >= _visitables.get("sysctls").size()) { _visitables.get("sysctls").add(builder); } else { _visitables.get("sysctls").set(index, builder);}
        if (index < 0 || index >= sysctls.size()) { sysctls.add(builder); } else { sysctls.set(index, builder);}
         return (A)this;
    }

    public A addToSysctls(io.fabric8.kubernetes.api.model.Sysctl... items) {
        if (this.sysctls == null) {this.sysctls = new java.util.ArrayList<io.fabric8.kubernetes.api.model.SysctlBuilder>();}
        for (io.fabric8.kubernetes.api.model.Sysctl item : items) {io.fabric8.kubernetes.api.model.SysctlBuilder builder = new io.fabric8.kubernetes.api.model.SysctlBuilder(item);_visitables.get("sysctls").add(builder);this.sysctls.add(builder);} return (A)this;
    }

    public A addAllToSysctls(java.util.Collection<io.fabric8.kubernetes.api.model.Sysctl> items) {
        if (this.sysctls == null) {this.sysctls = new java.util.ArrayList<io.fabric8.kubernetes.api.model.SysctlBuilder>();}
        for (io.fabric8.kubernetes.api.model.Sysctl item : items) {io.fabric8.kubernetes.api.model.SysctlBuilder builder = new io.fabric8.kubernetes.api.model.SysctlBuilder(item);_visitables.get("sysctls").add(builder);this.sysctls.add(builder);} return (A)this;
    }

    public A removeFromSysctls(io.fabric8.kubernetes.api.model.Sysctl... items) {
        for (io.fabric8.kubernetes.api.model.Sysctl item : items) {io.fabric8.kubernetes.api.model.SysctlBuilder builder = new io.fabric8.kubernetes.api.model.SysctlBuilder(item);_visitables.get("sysctls").remove(builder);if (this.sysctls != null) {this.sysctls.remove(builder);}} return (A)this;
    }

    public A removeAllFromSysctls(java.util.Collection<io.fabric8.kubernetes.api.model.Sysctl> items) {
        for (io.fabric8.kubernetes.api.model.Sysctl item : items) {io.fabric8.kubernetes.api.model.SysctlBuilder builder = new io.fabric8.kubernetes.api.model.SysctlBuilder(item);_visitables.get("sysctls").remove(builder);if (this.sysctls != null) {this.sysctls.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromSysctls(java.util.function.Predicate<io.fabric8.kubernetes.api.model.SysctlBuilder> predicate) {
        if (sysctls == null) return (A) this;
        final Iterator<io.fabric8.kubernetes.api.model.SysctlBuilder> each = sysctls.iterator();
        final List visitables = _visitables.get("sysctls");
        while (each.hasNext()) {
          io.fabric8.kubernetes.api.model.SysctlBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildSysctls instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.kubernetes.api.model.Sysctl> getSysctls() {
        return build(sysctls);
    }

    public java.util.List<io.fabric8.kubernetes.api.model.Sysctl> buildSysctls() {
        return build(sysctls);
    }

    public io.fabric8.kubernetes.api.model.Sysctl buildSysctl(int index) {
        return this.sysctls.get(index).build();
    }

    public io.fabric8.kubernetes.api.model.Sysctl buildFirstSysctl() {
        return this.sysctls.get(0).build();
    }

    public io.fabric8.kubernetes.api.model.Sysctl buildLastSysctl() {
        return this.sysctls.get(sysctls.size() - 1).build();
    }

    public io.fabric8.kubernetes.api.model.Sysctl buildMatchingSysctl(java.util.function.Predicate<io.fabric8.kubernetes.api.model.SysctlBuilder> predicate) {
        for (io.fabric8.kubernetes.api.model.SysctlBuilder item: sysctls) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingSysctl(java.util.function.Predicate<io.fabric8.kubernetes.api.model.SysctlBuilder> predicate) {
        for (io.fabric8.kubernetes.api.model.SysctlBuilder item: sysctls) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withSysctls(java.util.List<io.fabric8.kubernetes.api.model.Sysctl> sysctls) {
        if (this.sysctls != null) { _visitables.get("sysctls").removeAll(this.sysctls);}
        if (sysctls != null) {this.sysctls = new java.util.ArrayList<io.fabric8.kubernetes.api.model.SysctlBuilder>(); for (io.fabric8.kubernetes.api.model.Sysctl item : sysctls){this.addToSysctls(item);}} else { this.sysctls = null;} return (A) this;
    }

    public A withSysctls(io.fabric8.kubernetes.api.model.Sysctl... sysctls) {
        if (this.sysctls != null) {this.sysctls.clear();}
        if (sysctls != null) {for (io.fabric8.kubernetes.api.model.Sysctl item :sysctls){ this.addToSysctls(item);}} return (A) this;
    }

    public java.lang.Boolean hasSysctls() {
        return sysctls != null && !sysctls.isEmpty();
    }

    public A addNewSysctl(java.lang.String name,java.lang.String value) {
        return (A)addToSysctls(new Sysctl(name, value));
    }

    public io.fabric8.kubernetes.api.model.PodSecurityContextFluent.SysctlsNested<A> addNewSysctl() {
        return new io.fabric8.kubernetes.api.model.PodSecurityContextFluentImpl.SysctlsNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.PodSecurityContextFluent.SysctlsNested<A> addNewSysctlLike(io.fabric8.kubernetes.api.model.Sysctl item) {
        return new io.fabric8.kubernetes.api.model.PodSecurityContextFluentImpl.SysctlsNestedImpl(-1, item);
    }

    public io.fabric8.kubernetes.api.model.PodSecurityContextFluent.SysctlsNested<A> setNewSysctlLike(int index,io.fabric8.kubernetes.api.model.Sysctl item) {
        return new io.fabric8.kubernetes.api.model.PodSecurityContextFluentImpl.SysctlsNestedImpl(index, item);
    }

    public io.fabric8.kubernetes.api.model.PodSecurityContextFluent.SysctlsNested<A> editSysctl(int index) {
        if (sysctls.size() <= index) throw new RuntimeException("Can't edit sysctls. Index exceeds size.");
        return setNewSysctlLike(index, buildSysctl(index));
    }

    public io.fabric8.kubernetes.api.model.PodSecurityContextFluent.SysctlsNested<A> editFirstSysctl() {
        if (sysctls.size() == 0) throw new RuntimeException("Can't edit first sysctls. The list is empty.");
        return setNewSysctlLike(0, buildSysctl(0));
    }

    public io.fabric8.kubernetes.api.model.PodSecurityContextFluent.SysctlsNested<A> editLastSysctl() {
        int index = sysctls.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last sysctls. The list is empty.");
        return setNewSysctlLike(index, buildSysctl(index));
    }

    public io.fabric8.kubernetes.api.model.PodSecurityContextFluent.SysctlsNested<A> editMatchingSysctl(java.util.function.Predicate<io.fabric8.kubernetes.api.model.SysctlBuilder> predicate) {
        int index = -1;
        for (int i=0;i<sysctls.size();i++) { 
        if (predicate.test(sysctls.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching sysctls. No match found.");
        return setNewSysctlLike(index, buildSysctl(index));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildWindowsOptions instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.WindowsSecurityContextOptions getWindowsOptions() {
        return this.windowsOptions!=null?this.windowsOptions.build():null;
    }

    public io.fabric8.kubernetes.api.model.WindowsSecurityContextOptions buildWindowsOptions() {
        return this.windowsOptions!=null?this.windowsOptions.build():null;
    }

    public A withWindowsOptions(io.fabric8.kubernetes.api.model.WindowsSecurityContextOptions windowsOptions) {
        _visitables.get("windowsOptions").remove(this.windowsOptions);
        if (windowsOptions!=null){ this.windowsOptions= new io.fabric8.kubernetes.api.model.WindowsSecurityContextOptionsBuilder(windowsOptions); _visitables.get("windowsOptions").add(this.windowsOptions);} return (A) this;
    }

    public java.lang.Boolean hasWindowsOptions() {
        return this.windowsOptions != null;
    }

    public A withNewWindowsOptions(java.lang.String gmsaCredentialSpec,java.lang.String gmsaCredentialSpecName,java.lang.String runAsUserName) {
        return (A)withWindowsOptions(new WindowsSecurityContextOptions(gmsaCredentialSpec, gmsaCredentialSpecName, runAsUserName));
    }

    public io.fabric8.kubernetes.api.model.PodSecurityContextFluent.WindowsOptionsNested<A> withNewWindowsOptions() {
        return new io.fabric8.kubernetes.api.model.PodSecurityContextFluentImpl.WindowsOptionsNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.PodSecurityContextFluent.WindowsOptionsNested<A> withNewWindowsOptionsLike(io.fabric8.kubernetes.api.model.WindowsSecurityContextOptions item) {
        return new io.fabric8.kubernetes.api.model.PodSecurityContextFluentImpl.WindowsOptionsNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.PodSecurityContextFluent.WindowsOptionsNested<A> editWindowsOptions() {
        return withNewWindowsOptionsLike(getWindowsOptions());
    }

    public io.fabric8.kubernetes.api.model.PodSecurityContextFluent.WindowsOptionsNested<A> editOrNewWindowsOptions() {
        return withNewWindowsOptionsLike(getWindowsOptions() != null ? getWindowsOptions(): new io.fabric8.kubernetes.api.model.WindowsSecurityContextOptionsBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.PodSecurityContextFluent.WindowsOptionsNested<A> editOrNewWindowsOptionsLike(io.fabric8.kubernetes.api.model.WindowsSecurityContextOptions item) {
        return withNewWindowsOptionsLike(getWindowsOptions() != null ? getWindowsOptions(): item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PodSecurityContextFluentImpl that = (PodSecurityContextFluentImpl) o;
        if (fsGroup != null ? !fsGroup.equals(that.fsGroup) :that.fsGroup != null) return false;
        if (fsGroupChangePolicy != null ? !fsGroupChangePolicy.equals(that.fsGroupChangePolicy) :that.fsGroupChangePolicy != null) return false;
        if (runAsGroup != null ? !runAsGroup.equals(that.runAsGroup) :that.runAsGroup != null) return false;
        if (runAsNonRoot != null ? !runAsNonRoot.equals(that.runAsNonRoot) :that.runAsNonRoot != null) return false;
        if (runAsUser != null ? !runAsUser.equals(that.runAsUser) :that.runAsUser != null) return false;
        if (seLinuxOptions != null ? !seLinuxOptions.equals(that.seLinuxOptions) :that.seLinuxOptions != null) return false;
        if (seccompProfile != null ? !seccompProfile.equals(that.seccompProfile) :that.seccompProfile != null) return false;
        if (supplementalGroups != null ? !supplementalGroups.equals(that.supplementalGroups) :that.supplementalGroups != null) return false;
        if (sysctls != null ? !sysctls.equals(that.sysctls) :that.sysctls != null) return false;
        if (windowsOptions != null ? !windowsOptions.equals(that.windowsOptions) :that.windowsOptions != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fsGroup,  fsGroupChangePolicy,  runAsGroup,  runAsNonRoot,  runAsUser,  seLinuxOptions,  seccompProfile,  supplementalGroups,  sysctls,  windowsOptions,  super.hashCode());
    }

    public class SeLinuxOptionsNestedImpl<N> extends io.fabric8.kubernetes.api.model.SELinuxOptionsFluentImpl<io.fabric8.kubernetes.api.model.PodSecurityContextFluent.SeLinuxOptionsNested<N>> implements io.fabric8.kubernetes.api.model.PodSecurityContextFluent.SeLinuxOptionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.SELinuxOptionsBuilder builder;

            SeLinuxOptionsNestedImpl(io.fabric8.kubernetes.api.model.SELinuxOptions item) {
                this.builder = new io.fabric8.kubernetes.api.model.SELinuxOptionsBuilder(this, item);
                        
            }

            SeLinuxOptionsNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.SELinuxOptionsBuilder(this);
                        
            }

            public N and() {
                return (N) PodSecurityContextFluentImpl.this.withSeLinuxOptions(builder.build());
            }

            public N endSeLinuxOptions() {
                return and();
            }
    }


    public class SeccompProfileNestedImpl<N> extends io.fabric8.kubernetes.api.model.SeccompProfileFluentImpl<io.fabric8.kubernetes.api.model.PodSecurityContextFluent.SeccompProfileNested<N>> implements io.fabric8.kubernetes.api.model.PodSecurityContextFluent.SeccompProfileNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.SeccompProfileBuilder builder;

            SeccompProfileNestedImpl(io.fabric8.kubernetes.api.model.SeccompProfile item) {
                this.builder = new io.fabric8.kubernetes.api.model.SeccompProfileBuilder(this, item);
                        
            }

            SeccompProfileNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.SeccompProfileBuilder(this);
                        
            }

            public N and() {
                return (N) PodSecurityContextFluentImpl.this.withSeccompProfile(builder.build());
            }

            public N endSeccompProfile() {
                return and();
            }
    }


    public class SysctlsNestedImpl<N> extends io.fabric8.kubernetes.api.model.SysctlFluentImpl<io.fabric8.kubernetes.api.model.PodSecurityContextFluent.SysctlsNested<N>> implements io.fabric8.kubernetes.api.model.PodSecurityContextFluent.SysctlsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.SysctlBuilder builder;
        private final int index;

            SysctlsNestedImpl(int index,io.fabric8.kubernetes.api.model.Sysctl item) {
                this.index = index;
                this.builder = new io.fabric8.kubernetes.api.model.SysctlBuilder(this, item);
                        
            }

            SysctlsNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.kubernetes.api.model.SysctlBuilder(this);
                        
            }

            public N and() {
                return (N) PodSecurityContextFluentImpl.this.setToSysctls(index,builder.build());
            }

            public N endSysctl() {
                return and();
            }
    }


    public class WindowsOptionsNestedImpl<N> extends io.fabric8.kubernetes.api.model.WindowsSecurityContextOptionsFluentImpl<io.fabric8.kubernetes.api.model.PodSecurityContextFluent.WindowsOptionsNested<N>> implements io.fabric8.kubernetes.api.model.PodSecurityContextFluent.WindowsOptionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.WindowsSecurityContextOptionsBuilder builder;

            WindowsOptionsNestedImpl(io.fabric8.kubernetes.api.model.WindowsSecurityContextOptions item) {
                this.builder = new io.fabric8.kubernetes.api.model.WindowsSecurityContextOptionsBuilder(this, item);
                        
            }

            WindowsOptionsNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.WindowsSecurityContextOptionsBuilder(this);
                        
            }

            public N and() {
                return (N) PodSecurityContextFluentImpl.this.withWindowsOptions(builder.build());
            }

            public N endWindowsOptions() {
                return and();
            }
    }


}
