package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ServerAddressByClientCIDRBuilder extends io.fabric8.kubernetes.api.model.ServerAddressByClientCIDRFluentImpl<io.fabric8.kubernetes.api.model.ServerAddressByClientCIDRBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.ServerAddressByClientCIDR,io.fabric8.kubernetes.api.model.ServerAddressByClientCIDRBuilder> {

    io.fabric8.kubernetes.api.model.ServerAddressByClientCIDRFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ServerAddressByClientCIDRBuilder() {
        this(true);
    }

    public ServerAddressByClientCIDRBuilder(java.lang.Boolean validationEnabled) {
        this(new ServerAddressByClientCIDR(), validationEnabled);
    }

    public ServerAddressByClientCIDRBuilder(io.fabric8.kubernetes.api.model.ServerAddressByClientCIDRFluent<?> fluent) {
        this(fluent, true);
    }

    public ServerAddressByClientCIDRBuilder(io.fabric8.kubernetes.api.model.ServerAddressByClientCIDRFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ServerAddressByClientCIDR(), validationEnabled);
    }

    public ServerAddressByClientCIDRBuilder(io.fabric8.kubernetes.api.model.ServerAddressByClientCIDRFluent<?> fluent,io.fabric8.kubernetes.api.model.ServerAddressByClientCIDR instance) {
        this(fluent, instance, true);
    }

    public ServerAddressByClientCIDRBuilder(io.fabric8.kubernetes.api.model.ServerAddressByClientCIDRFluent<?> fluent,io.fabric8.kubernetes.api.model.ServerAddressByClientCIDR instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withClientCIDR(instance.getClientCIDR()); 
        fluent.withServerAddress(instance.getServerAddress()); 
        this.validationEnabled = validationEnabled; 
    }

    public ServerAddressByClientCIDRBuilder(io.fabric8.kubernetes.api.model.ServerAddressByClientCIDR instance) {
        this(instance,true);
    }

    public ServerAddressByClientCIDRBuilder(io.fabric8.kubernetes.api.model.ServerAddressByClientCIDR instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withClientCIDR(instance.getClientCIDR()); 
        this.withServerAddress(instance.getServerAddress()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.ServerAddressByClientCIDR build() {
        ServerAddressByClientCIDR buildable = new ServerAddressByClientCIDR(fluent.getClientCIDR(),fluent.getServerAddress());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ServerAddressByClientCIDRBuilder that = (ServerAddressByClientCIDRBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
