package io.fabric8.kubernetes.api.model;

import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.lang.Boolean;
import java.util.function.Predicate;

public class UpdateOptionsFluentImpl<A extends io.fabric8.kubernetes.api.model.UpdateOptionsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.UpdateOptionsFluent<A> {

    private java.lang.String apiVersion;
    private java.util.List<java.lang.String> dryRun = new java.util.ArrayList<java.lang.String>();
    private java.lang.String fieldManager;
    private java.lang.String kind;

    public UpdateOptionsFluentImpl() {
    }

    public UpdateOptionsFluentImpl(io.fabric8.kubernetes.api.model.UpdateOptions instance) {
        this.withApiVersion(instance.getApiVersion()); 
        this.withDryRun(instance.getDryRun()); 
        this.withFieldManager(instance.getFieldManager()); 
        this.withKind(instance.getKind()); 
    }

    public java.lang.String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(java.lang.String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public java.lang.Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withApiVersion instead.
     */
        public A withNewApiVersion(java.lang.String arg0) {
        return (A)withApiVersion(new String(arg0));
    }

    public A addToDryRun(int index,java.lang.String item) {
        if (this.dryRun == null) {this.dryRun = new java.util.ArrayList<java.lang.String>();}
        this.dryRun.add(index, item);
        return (A)this;
    }

    public A setToDryRun(int index,java.lang.String item) {
        if (this.dryRun == null) {this.dryRun = new java.util.ArrayList<java.lang.String>();}
        this.dryRun.set(index, item); return (A)this;
    }

    public A addToDryRun(java.lang.String... items) {
        if (this.dryRun == null) {this.dryRun = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.dryRun.add(item);} return (A)this;
    }

    public A addAllToDryRun(java.util.Collection<java.lang.String> items) {
        if (this.dryRun == null) {this.dryRun = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.dryRun.add(item);} return (A)this;
    }

    public A removeFromDryRun(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.dryRun!= null){ this.dryRun.remove(item);}} return (A)this;
    }

    public A removeAllFromDryRun(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.dryRun!= null){ this.dryRun.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getDryRun() {
        return this.dryRun;
    }

    public java.lang.String getDryRun(int index) {
        return this.dryRun.get(index);
    }

    public java.lang.String getFirstDryRun() {
        return this.dryRun.get(0);
    }

    public java.lang.String getLastDryRun() {
        return this.dryRun.get(dryRun.size() - 1);
    }

    public java.lang.String getMatchingDryRun(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: dryRun) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingDryRun(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: dryRun) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withDryRun(java.util.List<java.lang.String> dryRun) {
        if (this.dryRun != null) { _visitables.get("dryRun").removeAll(this.dryRun);}
        if (dryRun != null) {this.dryRun = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : dryRun){this.addToDryRun(item);}} else { this.dryRun = null;} return (A) this;
    }

    public A withDryRun(java.lang.String... dryRun) {
        if (this.dryRun != null) {this.dryRun.clear();}
        if (dryRun != null) {for (java.lang.String item :dryRun){ this.addToDryRun(item);}} return (A) this;
    }

    public java.lang.Boolean hasDryRun() {
        return dryRun != null && !dryRun.isEmpty();
    }

    public A addNewDryRun(java.lang.String arg0) {
        return (A)addToDryRun(new String(arg0));
    }

    public java.lang.String getFieldManager() {
        return this.fieldManager;
    }

    public A withFieldManager(java.lang.String fieldManager) {
        this.fieldManager=fieldManager; return (A) this;
    }

    public java.lang.Boolean hasFieldManager() {
        return this.fieldManager != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withFieldManager instead.
     */
        public A withNewFieldManager(java.lang.String arg0) {
        return (A)withFieldManager(new String(arg0));
    }

    public java.lang.String getKind() {
        return this.kind;
    }

    public A withKind(java.lang.String kind) {
        this.kind=kind; return (A) this;
    }

    public java.lang.Boolean hasKind() {
        return this.kind != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withKind instead.
     */
        public A withNewKind(java.lang.String arg0) {
        return (A)withKind(new String(arg0));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        UpdateOptionsFluentImpl that = (UpdateOptionsFluentImpl) o;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (dryRun != null ? !dryRun.equals(that.dryRun) :that.dryRun != null) return false;
        if (fieldManager != null ? !fieldManager.equals(that.fieldManager) :that.fieldManager != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiVersion,  dryRun,  fieldManager,  kind,  super.hashCode());
    }

}
