package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class AWSElasticBlockStoreVolumeSourceBuilder extends io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceFluentImpl<io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSource,io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceBuilder>{
  public AWSElasticBlockStoreVolumeSourceBuilder() {
    this(false);
  }
  public AWSElasticBlockStoreVolumeSourceBuilder(java.lang.Boolean validationEnabled) {
    this(new AWSElasticBlockStoreVolumeSource(), validationEnabled);
  }
  public AWSElasticBlockStoreVolumeSourceBuilder(io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public AWSElasticBlockStoreVolumeSourceBuilder(io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new AWSElasticBlockStoreVolumeSource(), validationEnabled);
  }
  public AWSElasticBlockStoreVolumeSourceBuilder(io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSource instance) {
    this(fluent, instance, false);
  }
  public AWSElasticBlockStoreVolumeSourceBuilder(io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withFsType(instance.getFsType()); 
    fluent.withPartition(instance.getPartition()); 
    fluent.withReadOnly(instance.getReadOnly()); 
    fluent.withVolumeID(instance.getVolumeID()); 
    this.validationEnabled = validationEnabled; 
  }
  public AWSElasticBlockStoreVolumeSourceBuilder(io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSource instance) {
    this(instance,false);
  }
  public AWSElasticBlockStoreVolumeSourceBuilder(io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withFsType(instance.getFsType()); 
    this.withPartition(instance.getPartition()); 
    this.withReadOnly(instance.getReadOnly()); 
    this.withVolumeID(instance.getVolumeID()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSource build() {
    AWSElasticBlockStoreVolumeSource buildable = new AWSElasticBlockStoreVolumeSource(fluent.getFsType(),fluent.getPartition(),fluent.getReadOnly(),fluent.getVolumeID());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AWSElasticBlockStoreVolumeSourceBuilder that = (AWSElasticBlockStoreVolumeSourceBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}