package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class AttachedVolumeBuilder extends io.fabric8.kubernetes.api.model.AttachedVolumeFluentImpl<io.fabric8.kubernetes.api.model.AttachedVolumeBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.AttachedVolume,io.fabric8.kubernetes.api.model.AttachedVolumeBuilder>{
  public AttachedVolumeBuilder() {
    this(false);
  }
  public AttachedVolumeBuilder(java.lang.Boolean validationEnabled) {
    this(new AttachedVolume(), validationEnabled);
  }
  public AttachedVolumeBuilder(io.fabric8.kubernetes.api.model.AttachedVolumeFluent<?> fluent) {
    this(fluent, false);
  }
  public AttachedVolumeBuilder(io.fabric8.kubernetes.api.model.AttachedVolumeFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new AttachedVolume(), validationEnabled);
  }
  public AttachedVolumeBuilder(io.fabric8.kubernetes.api.model.AttachedVolumeFluent<?> fluent,io.fabric8.kubernetes.api.model.AttachedVolume instance) {
    this(fluent, instance, false);
  }
  public AttachedVolumeBuilder(io.fabric8.kubernetes.api.model.AttachedVolumeFluent<?> fluent,io.fabric8.kubernetes.api.model.AttachedVolume instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDevicePath(instance.getDevicePath()); 
    fluent.withName(instance.getName()); 
    this.validationEnabled = validationEnabled; 
  }
  public AttachedVolumeBuilder(io.fabric8.kubernetes.api.model.AttachedVolume instance) {
    this(instance,false);
  }
  public AttachedVolumeBuilder(io.fabric8.kubernetes.api.model.AttachedVolume instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withDevicePath(instance.getDevicePath()); 
    this.withName(instance.getName()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.AttachedVolumeFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.AttachedVolume build() {
    AttachedVolume buildable = new AttachedVolume(fluent.getDevicePath(),fluent.getName());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AttachedVolumeBuilder that = (AttachedVolumeBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}