package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class AzureDiskVolumeSourceBuilder extends io.fabric8.kubernetes.api.model.AzureDiskVolumeSourceFluentImpl<io.fabric8.kubernetes.api.model.AzureDiskVolumeSourceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.AzureDiskVolumeSource,io.fabric8.kubernetes.api.model.AzureDiskVolumeSourceBuilder>{
  public AzureDiskVolumeSourceBuilder() {
    this(false);
  }
  public AzureDiskVolumeSourceBuilder(java.lang.Boolean validationEnabled) {
    this(new AzureDiskVolumeSource(), validationEnabled);
  }
  public AzureDiskVolumeSourceBuilder(io.fabric8.kubernetes.api.model.AzureDiskVolumeSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public AzureDiskVolumeSourceBuilder(io.fabric8.kubernetes.api.model.AzureDiskVolumeSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new AzureDiskVolumeSource(), validationEnabled);
  }
  public AzureDiskVolumeSourceBuilder(io.fabric8.kubernetes.api.model.AzureDiskVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.AzureDiskVolumeSource instance) {
    this(fluent, instance, false);
  }
  public AzureDiskVolumeSourceBuilder(io.fabric8.kubernetes.api.model.AzureDiskVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.AzureDiskVolumeSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCachingMode(instance.getCachingMode()); 
    fluent.withDiskName(instance.getDiskName()); 
    fluent.withDiskURI(instance.getDiskURI()); 
    fluent.withFsType(instance.getFsType()); 
    fluent.withKind(instance.getKind()); 
    fluent.withReadOnly(instance.getReadOnly()); 
    this.validationEnabled = validationEnabled; 
  }
  public AzureDiskVolumeSourceBuilder(io.fabric8.kubernetes.api.model.AzureDiskVolumeSource instance) {
    this(instance,false);
  }
  public AzureDiskVolumeSourceBuilder(io.fabric8.kubernetes.api.model.AzureDiskVolumeSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withCachingMode(instance.getCachingMode()); 
    this.withDiskName(instance.getDiskName()); 
    this.withDiskURI(instance.getDiskURI()); 
    this.withFsType(instance.getFsType()); 
    this.withKind(instance.getKind()); 
    this.withReadOnly(instance.getReadOnly()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.AzureDiskVolumeSourceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.AzureDiskVolumeSource build() {
    AzureDiskVolumeSource buildable = new AzureDiskVolumeSource(fluent.getCachingMode(),fluent.getDiskName(),fluent.getDiskURI(),fluent.getFsType(),fluent.getKind(),fluent.getReadOnly());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AzureDiskVolumeSourceBuilder that = (AzureDiskVolumeSourceBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}