package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class CSIPersistentVolumeSourceBuilder extends io.fabric8.kubernetes.api.model.CSIPersistentVolumeSourceFluentImpl<io.fabric8.kubernetes.api.model.CSIPersistentVolumeSourceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.CSIPersistentVolumeSource,io.fabric8.kubernetes.api.model.CSIPersistentVolumeSourceBuilder>{
  public CSIPersistentVolumeSourceBuilder() {
    this(false);
  }
  public CSIPersistentVolumeSourceBuilder(java.lang.Boolean validationEnabled) {
    this(new CSIPersistentVolumeSource(), validationEnabled);
  }
  public CSIPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.CSIPersistentVolumeSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public CSIPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.CSIPersistentVolumeSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new CSIPersistentVolumeSource(), validationEnabled);
  }
  public CSIPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.CSIPersistentVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.CSIPersistentVolumeSource instance) {
    this(fluent, instance, false);
  }
  public CSIPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.CSIPersistentVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.CSIPersistentVolumeSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withControllerExpandSecretRef(instance.getControllerExpandSecretRef()); 
    fluent.withControllerPublishSecretRef(instance.getControllerPublishSecretRef()); 
    fluent.withDriver(instance.getDriver()); 
    fluent.withFsType(instance.getFsType()); 
    fluent.withNodePublishSecretRef(instance.getNodePublishSecretRef()); 
    fluent.withNodeStageSecretRef(instance.getNodeStageSecretRef()); 
    fluent.withReadOnly(instance.getReadOnly()); 
    fluent.withVolumeAttributes(instance.getVolumeAttributes()); 
    fluent.withVolumeHandle(instance.getVolumeHandle()); 
    this.validationEnabled = validationEnabled; 
  }
  public CSIPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.CSIPersistentVolumeSource instance) {
    this(instance,false);
  }
  public CSIPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.CSIPersistentVolumeSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withControllerExpandSecretRef(instance.getControllerExpandSecretRef()); 
    this.withControllerPublishSecretRef(instance.getControllerPublishSecretRef()); 
    this.withDriver(instance.getDriver()); 
    this.withFsType(instance.getFsType()); 
    this.withNodePublishSecretRef(instance.getNodePublishSecretRef()); 
    this.withNodeStageSecretRef(instance.getNodeStageSecretRef()); 
    this.withReadOnly(instance.getReadOnly()); 
    this.withVolumeAttributes(instance.getVolumeAttributes()); 
    this.withVolumeHandle(instance.getVolumeHandle()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.CSIPersistentVolumeSourceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.CSIPersistentVolumeSource build() {
    CSIPersistentVolumeSource buildable = new CSIPersistentVolumeSource(fluent.getControllerExpandSecretRef(),fluent.getControllerPublishSecretRef(),fluent.getDriver(),fluent.getFsType(),fluent.getNodePublishSecretRef(),fluent.getNodeStageSecretRef(),fluent.getReadOnly(),fluent.getVolumeAttributes(),fluent.getVolumeHandle());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CSIPersistentVolumeSourceBuilder that = (CSIPersistentVolumeSourceBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}