package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class NodeSpecBuilder extends io.fabric8.kubernetes.api.model.NodeSpecFluentImpl<io.fabric8.kubernetes.api.model.NodeSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.NodeSpec,io.fabric8.kubernetes.api.model.NodeSpecBuilder>{
  public NodeSpecBuilder() {
    this(false);
  }
  public NodeSpecBuilder(java.lang.Boolean validationEnabled) {
    this(new NodeSpec(), validationEnabled);
  }
  public NodeSpecBuilder(io.fabric8.kubernetes.api.model.NodeSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public NodeSpecBuilder(io.fabric8.kubernetes.api.model.NodeSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new NodeSpec(), validationEnabled);
  }
  public NodeSpecBuilder(io.fabric8.kubernetes.api.model.NodeSpecFluent<?> fluent,io.fabric8.kubernetes.api.model.NodeSpec instance) {
    this(fluent, instance, false);
  }
  public NodeSpecBuilder(io.fabric8.kubernetes.api.model.NodeSpecFluent<?> fluent,io.fabric8.kubernetes.api.model.NodeSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withConfigSource(instance.getConfigSource()); 
    fluent.withExternalID(instance.getExternalID()); 
    fluent.withPodCIDR(instance.getPodCIDR()); 
    fluent.withPodCIDRs(instance.getPodCIDRs()); 
    fluent.withProviderID(instance.getProviderID()); 
    fluent.withTaints(instance.getTaints()); 
    fluent.withUnschedulable(instance.getUnschedulable()); 
    this.validationEnabled = validationEnabled; 
  }
  public NodeSpecBuilder(io.fabric8.kubernetes.api.model.NodeSpec instance) {
    this(instance,false);
  }
  public NodeSpecBuilder(io.fabric8.kubernetes.api.model.NodeSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withConfigSource(instance.getConfigSource()); 
    this.withExternalID(instance.getExternalID()); 
    this.withPodCIDR(instance.getPodCIDR()); 
    this.withPodCIDRs(instance.getPodCIDRs()); 
    this.withProviderID(instance.getProviderID()); 
    this.withTaints(instance.getTaints()); 
    this.withUnschedulable(instance.getUnschedulable()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.NodeSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.NodeSpec build() {
    NodeSpec buildable = new NodeSpec(fluent.getConfigSource(),fluent.getExternalID(),fluent.getPodCIDR(),fluent.getPodCIDRs(),fluent.getProviderID(),fluent.getTaints(),fluent.getUnschedulable());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NodeSpecBuilder that = (NodeSpecBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}