package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class PodStatusBuilder extends io.fabric8.kubernetes.api.model.PodStatusFluentImpl<io.fabric8.kubernetes.api.model.PodStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.PodStatus,io.fabric8.kubernetes.api.model.PodStatusBuilder>{
  public PodStatusBuilder() {
    this(false);
  }
  public PodStatusBuilder(java.lang.Boolean validationEnabled) {
    this(new PodStatus(), validationEnabled);
  }
  public PodStatusBuilder(io.fabric8.kubernetes.api.model.PodStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public PodStatusBuilder(io.fabric8.kubernetes.api.model.PodStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new PodStatus(), validationEnabled);
  }
  public PodStatusBuilder(io.fabric8.kubernetes.api.model.PodStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.PodStatus instance) {
    this(fluent, instance, false);
  }
  public PodStatusBuilder(io.fabric8.kubernetes.api.model.PodStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.PodStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withConditions(instance.getConditions()); 
    fluent.withContainerStatuses(instance.getContainerStatuses()); 
    fluent.withEphemeralContainerStatuses(instance.getEphemeralContainerStatuses()); 
    fluent.withHostIP(instance.getHostIP()); 
    fluent.withInitContainerStatuses(instance.getInitContainerStatuses()); 
    fluent.withMessage(instance.getMessage()); 
    fluent.withNominatedNodeName(instance.getNominatedNodeName()); 
    fluent.withPhase(instance.getPhase()); 
    fluent.withPodIP(instance.getPodIP()); 
    fluent.withPodIPs(instance.getPodIPs()); 
    fluent.withQosClass(instance.getQosClass()); 
    fluent.withReason(instance.getReason()); 
    fluent.withStartTime(instance.getStartTime()); 
    this.validationEnabled = validationEnabled; 
  }
  public PodStatusBuilder(io.fabric8.kubernetes.api.model.PodStatus instance) {
    this(instance,false);
  }
  public PodStatusBuilder(io.fabric8.kubernetes.api.model.PodStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withConditions(instance.getConditions()); 
    this.withContainerStatuses(instance.getContainerStatuses()); 
    this.withEphemeralContainerStatuses(instance.getEphemeralContainerStatuses()); 
    this.withHostIP(instance.getHostIP()); 
    this.withInitContainerStatuses(instance.getInitContainerStatuses()); 
    this.withMessage(instance.getMessage()); 
    this.withNominatedNodeName(instance.getNominatedNodeName()); 
    this.withPhase(instance.getPhase()); 
    this.withPodIP(instance.getPodIP()); 
    this.withPodIPs(instance.getPodIPs()); 
    this.withQosClass(instance.getQosClass()); 
    this.withReason(instance.getReason()); 
    this.withStartTime(instance.getStartTime()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.PodStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.PodStatus build() {
    PodStatus buildable = new PodStatus(fluent.getConditions(),fluent.getContainerStatuses(),fluent.getEphemeralContainerStatuses(),fluent.getHostIP(),fluent.getInitContainerStatuses(),fluent.getMessage(),fluent.getNominatedNodeName(),fluent.getPhase(),fluent.getPodIP(),fluent.getPodIPs(),fluent.getQosClass(),fluent.getReason(),fluent.getStartTime());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PodStatusBuilder that = (PodStatusBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}