package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ResourceQuotaListBuilder extends io.fabric8.kubernetes.api.model.ResourceQuotaListFluentImpl<io.fabric8.kubernetes.api.model.ResourceQuotaListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.ResourceQuotaList,io.fabric8.kubernetes.api.model.ResourceQuotaListBuilder>{
  public ResourceQuotaListBuilder() {
    this(false);
  }
  public ResourceQuotaListBuilder(java.lang.Boolean validationEnabled) {
    this(new ResourceQuotaList(), validationEnabled);
  }
  public ResourceQuotaListBuilder(io.fabric8.kubernetes.api.model.ResourceQuotaListFluent<?> fluent) {
    this(fluent, false);
  }
  public ResourceQuotaListBuilder(io.fabric8.kubernetes.api.model.ResourceQuotaListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ResourceQuotaList(), validationEnabled);
  }
  public ResourceQuotaListBuilder(io.fabric8.kubernetes.api.model.ResourceQuotaListFluent<?> fluent,io.fabric8.kubernetes.api.model.ResourceQuotaList instance) {
    this(fluent, instance, false);
  }
  public ResourceQuotaListBuilder(io.fabric8.kubernetes.api.model.ResourceQuotaListFluent<?> fluent,io.fabric8.kubernetes.api.model.ResourceQuotaList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  public ResourceQuotaListBuilder(io.fabric8.kubernetes.api.model.ResourceQuotaList instance) {
    this(instance,false);
  }
  public ResourceQuotaListBuilder(io.fabric8.kubernetes.api.model.ResourceQuotaList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.ResourceQuotaListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.ResourceQuotaList build() {
    ResourceQuotaList buildable = new ResourceQuotaList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ResourceQuotaListBuilder that = (ResourceQuotaListBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}