package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ServiceStatusBuilder extends io.fabric8.kubernetes.api.model.ServiceStatusFluentImpl<io.fabric8.kubernetes.api.model.ServiceStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.ServiceStatus,io.fabric8.kubernetes.api.model.ServiceStatusBuilder>{
  public ServiceStatusBuilder() {
    this(false);
  }
  public ServiceStatusBuilder(java.lang.Boolean validationEnabled) {
    this(new ServiceStatus(), validationEnabled);
  }
  public ServiceStatusBuilder(io.fabric8.kubernetes.api.model.ServiceStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceStatusBuilder(io.fabric8.kubernetes.api.model.ServiceStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ServiceStatus(), validationEnabled);
  }
  public ServiceStatusBuilder(io.fabric8.kubernetes.api.model.ServiceStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.ServiceStatus instance) {
    this(fluent, instance, false);
  }
  public ServiceStatusBuilder(io.fabric8.kubernetes.api.model.ServiceStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.ServiceStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withConditions(instance.getConditions()); 
    fluent.withLoadBalancer(instance.getLoadBalancer()); 
    this.validationEnabled = validationEnabled; 
  }
  public ServiceStatusBuilder(io.fabric8.kubernetes.api.model.ServiceStatus instance) {
    this(instance,false);
  }
  public ServiceStatusBuilder(io.fabric8.kubernetes.api.model.ServiceStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withConditions(instance.getConditions()); 
    this.withLoadBalancer(instance.getLoadBalancer()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.ServiceStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.ServiceStatus build() {
    ServiceStatus buildable = new ServiceStatus(fluent.getConditions(),fluent.getLoadBalancer());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ServiceStatusBuilder that = (ServiceStatusBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}