package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class StatusBuilder extends io.fabric8.kubernetes.api.model.StatusFluentImpl<io.fabric8.kubernetes.api.model.StatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.Status,io.fabric8.kubernetes.api.model.StatusBuilder>{
  public StatusBuilder() {
    this(false);
  }
  public StatusBuilder(java.lang.Boolean validationEnabled) {
    this(new Status(), validationEnabled);
  }
  public StatusBuilder(io.fabric8.kubernetes.api.model.StatusFluent<?> fluent) {
    this(fluent, false);
  }
  public StatusBuilder(io.fabric8.kubernetes.api.model.StatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Status(), validationEnabled);
  }
  public StatusBuilder(io.fabric8.kubernetes.api.model.StatusFluent<?> fluent,io.fabric8.kubernetes.api.model.Status instance) {
    this(fluent, instance, false);
  }
  public StatusBuilder(io.fabric8.kubernetes.api.model.StatusFluent<?> fluent,io.fabric8.kubernetes.api.model.Status instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withCode(instance.getCode()); 
    fluent.withDetails(instance.getDetails()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMessage(instance.getMessage()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withReason(instance.getReason()); 
    fluent.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  public StatusBuilder(io.fabric8.kubernetes.api.model.Status instance) {
    this(instance,false);
  }
  public StatusBuilder(io.fabric8.kubernetes.api.model.Status instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withCode(instance.getCode()); 
    this.withDetails(instance.getDetails()); 
    this.withKind(instance.getKind()); 
    this.withMessage(instance.getMessage()); 
    this.withMetadata(instance.getMetadata()); 
    this.withReason(instance.getReason()); 
    this.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.StatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.Status build() {
    Status buildable = new Status(fluent.getApiVersion(),fluent.getCode(),fluent.getDetails(),fluent.getKind(),fluent.getMessage(),fluent.getMetadata(),fluent.getReason(),fluent.getStatus());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    StatusBuilder that = (StatusBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}