package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class TypedLocalObjectReferenceBuilder extends io.fabric8.kubernetes.api.model.TypedLocalObjectReferenceFluentImpl<io.fabric8.kubernetes.api.model.TypedLocalObjectReferenceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.TypedLocalObjectReference,io.fabric8.kubernetes.api.model.TypedLocalObjectReferenceBuilder>{
  public TypedLocalObjectReferenceBuilder() {
    this(false);
  }
  public TypedLocalObjectReferenceBuilder(java.lang.Boolean validationEnabled) {
    this(new TypedLocalObjectReference(), validationEnabled);
  }
  public TypedLocalObjectReferenceBuilder(io.fabric8.kubernetes.api.model.TypedLocalObjectReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public TypedLocalObjectReferenceBuilder(io.fabric8.kubernetes.api.model.TypedLocalObjectReferenceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new TypedLocalObjectReference(), validationEnabled);
  }
  public TypedLocalObjectReferenceBuilder(io.fabric8.kubernetes.api.model.TypedLocalObjectReferenceFluent<?> fluent,io.fabric8.kubernetes.api.model.TypedLocalObjectReference instance) {
    this(fluent, instance, false);
  }
  public TypedLocalObjectReferenceBuilder(io.fabric8.kubernetes.api.model.TypedLocalObjectReferenceFluent<?> fluent,io.fabric8.kubernetes.api.model.TypedLocalObjectReference instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiGroup(instance.getApiGroup()); 
    fluent.withKind(instance.getKind()); 
    fluent.withName(instance.getName()); 
    this.validationEnabled = validationEnabled; 
  }
  public TypedLocalObjectReferenceBuilder(io.fabric8.kubernetes.api.model.TypedLocalObjectReference instance) {
    this(instance,false);
  }
  public TypedLocalObjectReferenceBuilder(io.fabric8.kubernetes.api.model.TypedLocalObjectReference instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiGroup(instance.getApiGroup()); 
    this.withKind(instance.getKind()); 
    this.withName(instance.getName()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.TypedLocalObjectReferenceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.TypedLocalObjectReference build() {
    TypedLocalObjectReference buildable = new TypedLocalObjectReference(fluent.getApiGroup(),fluent.getKind(),fluent.getName());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TypedLocalObjectReferenceBuilder that = (TypedLocalObjectReferenceBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}