package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class EndpointsListBuilder extends io.fabric8.kubernetes.api.model.EndpointsListFluentImpl<io.fabric8.kubernetes.api.model.EndpointsListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.EndpointsList,io.fabric8.kubernetes.api.model.EndpointsListBuilder>{
  public EndpointsListBuilder() {
    this(false);
  }
  public EndpointsListBuilder(java.lang.Boolean validationEnabled) {
    this(new EndpointsList(), validationEnabled);
  }
  public EndpointsListBuilder(io.fabric8.kubernetes.api.model.EndpointsListFluent<?> fluent) {
    this(fluent, false);
  }
  public EndpointsListBuilder(io.fabric8.kubernetes.api.model.EndpointsListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new EndpointsList(), validationEnabled);
  }
  public EndpointsListBuilder(io.fabric8.kubernetes.api.model.EndpointsListFluent<?> fluent,io.fabric8.kubernetes.api.model.EndpointsList instance) {
    this(fluent, instance, false);
  }
  public EndpointsListBuilder(io.fabric8.kubernetes.api.model.EndpointsListFluent<?> fluent,io.fabric8.kubernetes.api.model.EndpointsList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  public EndpointsListBuilder(io.fabric8.kubernetes.api.model.EndpointsList instance) {
    this(instance,false);
  }
  public EndpointsListBuilder(io.fabric8.kubernetes.api.model.EndpointsList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.EndpointsListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.EndpointsList build() {
    EndpointsList buildable = new EndpointsList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    EndpointsListBuilder that = (EndpointsListBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}