package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class EphemeralVolumeSourceBuilder extends io.fabric8.kubernetes.api.model.EphemeralVolumeSourceFluentImpl<io.fabric8.kubernetes.api.model.EphemeralVolumeSourceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.EphemeralVolumeSource,io.fabric8.kubernetes.api.model.EphemeralVolumeSourceBuilder>{
  public EphemeralVolumeSourceBuilder() {
    this(false);
  }
  public EphemeralVolumeSourceBuilder(java.lang.Boolean validationEnabled) {
    this(new EphemeralVolumeSource(), validationEnabled);
  }
  public EphemeralVolumeSourceBuilder(io.fabric8.kubernetes.api.model.EphemeralVolumeSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public EphemeralVolumeSourceBuilder(io.fabric8.kubernetes.api.model.EphemeralVolumeSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new EphemeralVolumeSource(), validationEnabled);
  }
  public EphemeralVolumeSourceBuilder(io.fabric8.kubernetes.api.model.EphemeralVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.EphemeralVolumeSource instance) {
    this(fluent, instance, false);
  }
  public EphemeralVolumeSourceBuilder(io.fabric8.kubernetes.api.model.EphemeralVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.EphemeralVolumeSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withVolumeClaimTemplate(instance.getVolumeClaimTemplate()); 
    this.validationEnabled = validationEnabled; 
  }
  public EphemeralVolumeSourceBuilder(io.fabric8.kubernetes.api.model.EphemeralVolumeSource instance) {
    this(instance,false);
  }
  public EphemeralVolumeSourceBuilder(io.fabric8.kubernetes.api.model.EphemeralVolumeSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withVolumeClaimTemplate(instance.getVolumeClaimTemplate()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.EphemeralVolumeSourceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.EphemeralVolumeSource build() {
    EphemeralVolumeSource buildable = new EphemeralVolumeSource(fluent.getVolumeClaimTemplate());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    EphemeralVolumeSourceBuilder that = (EphemeralVolumeSourceBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}