package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class HTTPGetActionBuilder extends io.fabric8.kubernetes.api.model.HTTPGetActionFluentImpl<io.fabric8.kubernetes.api.model.HTTPGetActionBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.HTTPGetAction,io.fabric8.kubernetes.api.model.HTTPGetActionBuilder>{
  public HTTPGetActionBuilder() {
    this(false);
  }
  public HTTPGetActionBuilder(java.lang.Boolean validationEnabled) {
    this(new HTTPGetAction(), validationEnabled);
  }
  public HTTPGetActionBuilder(io.fabric8.kubernetes.api.model.HTTPGetActionFluent<?> fluent) {
    this(fluent, false);
  }
  public HTTPGetActionBuilder(io.fabric8.kubernetes.api.model.HTTPGetActionFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new HTTPGetAction(), validationEnabled);
  }
  public HTTPGetActionBuilder(io.fabric8.kubernetes.api.model.HTTPGetActionFluent<?> fluent,io.fabric8.kubernetes.api.model.HTTPGetAction instance) {
    this(fluent, instance, false);
  }
  public HTTPGetActionBuilder(io.fabric8.kubernetes.api.model.HTTPGetActionFluent<?> fluent,io.fabric8.kubernetes.api.model.HTTPGetAction instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withHost(instance.getHost()); 
    fluent.withHttpHeaders(instance.getHttpHeaders()); 
    fluent.withPath(instance.getPath()); 
    fluent.withPort(instance.getPort()); 
    fluent.withScheme(instance.getScheme()); 
    this.validationEnabled = validationEnabled; 
  }
  public HTTPGetActionBuilder(io.fabric8.kubernetes.api.model.HTTPGetAction instance) {
    this(instance,false);
  }
  public HTTPGetActionBuilder(io.fabric8.kubernetes.api.model.HTTPGetAction instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withHost(instance.getHost()); 
    this.withHttpHeaders(instance.getHttpHeaders()); 
    this.withPath(instance.getPath()); 
    this.withPort(instance.getPort()); 
    this.withScheme(instance.getScheme()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.HTTPGetActionFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.HTTPGetAction build() {
    HTTPGetAction buildable = new HTTPGetAction(fluent.getHost(),fluent.getHttpHeaders(),fluent.getPath(),fluent.getPort(),fluent.getScheme());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    HTTPGetActionBuilder that = (HTTPGetActionBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}