package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class LimitRangeSpecBuilder extends io.fabric8.kubernetes.api.model.LimitRangeSpecFluentImpl<io.fabric8.kubernetes.api.model.LimitRangeSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.LimitRangeSpec,io.fabric8.kubernetes.api.model.LimitRangeSpecBuilder>{
  public LimitRangeSpecBuilder() {
    this(false);
  }
  public LimitRangeSpecBuilder(java.lang.Boolean validationEnabled) {
    this(new LimitRangeSpec(), validationEnabled);
  }
  public LimitRangeSpecBuilder(io.fabric8.kubernetes.api.model.LimitRangeSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public LimitRangeSpecBuilder(io.fabric8.kubernetes.api.model.LimitRangeSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new LimitRangeSpec(), validationEnabled);
  }
  public LimitRangeSpecBuilder(io.fabric8.kubernetes.api.model.LimitRangeSpecFluent<?> fluent,io.fabric8.kubernetes.api.model.LimitRangeSpec instance) {
    this(fluent, instance, false);
  }
  public LimitRangeSpecBuilder(io.fabric8.kubernetes.api.model.LimitRangeSpecFluent<?> fluent,io.fabric8.kubernetes.api.model.LimitRangeSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLimits(instance.getLimits()); 
    this.validationEnabled = validationEnabled; 
  }
  public LimitRangeSpecBuilder(io.fabric8.kubernetes.api.model.LimitRangeSpec instance) {
    this(instance,false);
  }
  public LimitRangeSpecBuilder(io.fabric8.kubernetes.api.model.LimitRangeSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withLimits(instance.getLimits()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.LimitRangeSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.LimitRangeSpec build() {
    LimitRangeSpec buildable = new LimitRangeSpec(fluent.getLimits());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    LimitRangeSpecBuilder that = (LimitRangeSpecBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}