package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public class PersistentVolumeClaimStatusFluentImpl<A extends io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatusFluent<A>{
  public PersistentVolumeClaimStatusFluentImpl() {
  }
  public PersistentVolumeClaimStatusFluentImpl(io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatus instance) {
    this.withAccessModes(instance.getAccessModes()); 
    this.withCapacity(instance.getCapacity()); 
    this.withConditions(instance.getConditions()); 
    this.withPhase(instance.getPhase()); 
  }
  private java.util.List<java.lang.String> accessModes = new java.util.ArrayList<java.lang.String>();
  private java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> capacity;
  private java.util.List<io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionBuilder> conditions =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionBuilder>();
  private java.lang.String phase;
  public A addToAccessModes(java.lang.Integer index,java.lang.String item) {
    if (this.accessModes == null) {this.accessModes = new java.util.ArrayList<java.lang.String>();}
    this.accessModes.add(index, item);
    return (A)this;
  }
  public A setToAccessModes(java.lang.Integer index,java.lang.String item) {
    if (this.accessModes == null) {this.accessModes = new java.util.ArrayList<java.lang.String>();}
    this.accessModes.set(index, item); return (A)this;
  }
  public A addToAccessModes(java.lang.String... items) {
    if (this.accessModes == null) {this.accessModes = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.accessModes.add(item);} return (A)this;
  }
  public A addAllToAccessModes(java.util.Collection<java.lang.String> items) {
    if (this.accessModes == null) {this.accessModes = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.accessModes.add(item);} return (A)this;
  }
  public A removeFromAccessModes(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.accessModes!= null){ this.accessModes.remove(item);}} return (A)this;
  }
  public A removeAllFromAccessModes(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.accessModes!= null){ this.accessModes.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getAccessModes() {
    return this.accessModes;
  }
  public java.lang.String getAccessMode(java.lang.Integer index) {
    return this.accessModes.get(index);
  }
  public java.lang.String getFirstAccessMode() {
    return this.accessModes.get(0);
  }
  public java.lang.String getLastAccessMode() {
    return this.accessModes.get(accessModes.size() - 1);
  }
  public java.lang.String getMatchingAccessMode(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: accessModes) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingAccessMode(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: accessModes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAccessModes(java.util.List<java.lang.String> accessModes) {
    if (accessModes != null) {this.accessModes = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : accessModes){this.addToAccessModes(item);}} else { this.accessModes = null;} return (A) this;
  }
  public A withAccessModes(java.lang.String... accessModes) {
    if (this.accessModes != null) {this.accessModes.clear();}
    if (accessModes != null) {for (java.lang.String item :accessModes){ this.addToAccessModes(item);}} return (A) this;
  }
  public java.lang.Boolean hasAccessModes() {
    return accessModes != null && !accessModes.isEmpty();
  }
  public A addNewAccessMode(java.lang.String arg0) {
    return (A)addToAccessModes(new String(arg0));
  }
  public A addToCapacity(java.lang.String key,io.fabric8.kubernetes.api.model.Quantity value) {
    if(this.capacity == null && key != null && value != null) { this.capacity = new java.util.LinkedHashMap<java.lang.String,io.fabric8.kubernetes.api.model.Quantity>(); }
    if(key != null && value != null) {this.capacity.put(key, value);} return (A)this;
  }
  public A addToCapacity(java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> map) {
    if(this.capacity == null && map != null) { this.capacity = new java.util.LinkedHashMap<java.lang.String,io.fabric8.kubernetes.api.model.Quantity>(); }
    if(map != null) { this.capacity.putAll(map);} return (A)this;
  }
  public A removeFromCapacity(java.lang.String key) {
    if(this.capacity == null) { return (A) this; }
    if(key != null && this.capacity != null) {this.capacity.remove(key);} return (A)this;
  }
  public A removeFromCapacity(java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> map) {
    if(this.capacity == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.capacity != null){this.capacity.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> getCapacity() {
    return this.capacity;
  }
  public <K,V>A withCapacity(java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> capacity) {
    if (capacity == null) { this.capacity =  null;} else {this.capacity = new java.util.LinkedHashMap<java.lang.String,io.fabric8.kubernetes.api.model.Quantity>(capacity);} return (A) this;
  }
  public java.lang.Boolean hasCapacity() {
    return this.capacity != null;
  }
  public A addToConditions(java.lang.Integer index,io.fabric8.kubernetes.api.model.PersistentVolumeClaimCondition item) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionBuilder>();}
    io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionBuilder builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
  }
  public A setToConditions(java.lang.Integer index,io.fabric8.kubernetes.api.model.PersistentVolumeClaimCondition item) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionBuilder>();}
    io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionBuilder builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionBuilder(item);
    if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
    if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
     return (A)this;
  }
  public A addToConditions(io.fabric8.kubernetes.api.model.PersistentVolumeClaimCondition... items) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionBuilder>();}
    for (io.fabric8.kubernetes.api.model.PersistentVolumeClaimCondition item : items) {io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionBuilder builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(java.util.Collection<io.fabric8.kubernetes.api.model.PersistentVolumeClaimCondition> items) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionBuilder>();}
    for (io.fabric8.kubernetes.api.model.PersistentVolumeClaimCondition item : items) {io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionBuilder builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.kubernetes.api.model.PersistentVolumeClaimCondition... items) {
    for (io.fabric8.kubernetes.api.model.PersistentVolumeClaimCondition item : items) {io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionBuilder builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(java.util.Collection<io.fabric8.kubernetes.api.model.PersistentVolumeClaimCondition> items) {
    for (io.fabric8.kubernetes.api.model.PersistentVolumeClaimCondition item : items) {io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionBuilder builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(java.util.function.Predicate<io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.PersistentVolumeClaimCondition> getConditions() {
    return build(conditions);
  }
  public java.util.List<io.fabric8.kubernetes.api.model.PersistentVolumeClaimCondition> buildConditions() {
    return build(conditions);
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeClaimCondition buildCondition(java.lang.Integer index) {
    return this.conditions.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeClaimCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeClaimCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeClaimCondition buildMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(java.util.List<io.fabric8.kubernetes.api.model.PersistentVolumeClaimCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
    if (conditions != null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionBuilder>(); for (io.fabric8.kubernetes.api.model.PersistentVolumeClaimCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.kubernetes.api.model.PersistentVolumeClaimCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (io.fabric8.kubernetes.api.model.PersistentVolumeClaimCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public java.lang.Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatusFluent.ConditionsNested<A> addNewCondition() {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatusFluentImpl.ConditionsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatusFluent.ConditionsNested<A> addNewConditionLike(io.fabric8.kubernetes.api.model.PersistentVolumeClaimCondition item) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatusFluent.ConditionsNested<A> setNewConditionLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.PersistentVolumeClaimCondition item) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatusFluent.ConditionsNested<A> editCondition(java.lang.Integer index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatusFluent.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatusFluent.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatusFluent.ConditionsNested<A> editMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public java.lang.String getPhase() {
    return this.phase;
  }
  public A withPhase(java.lang.String phase) {
    this.phase=phase; return (A) this;
  }
  public java.lang.Boolean hasPhase() {
    return this.phase != null;
  }
  
  /**
   * Method is deprecated. use withPhase instead.
   */
  @java.lang.Deprecated
  public A withNewPhase(java.lang.String arg0) {
    return (A)withPhase(new String(arg0));
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PersistentVolumeClaimStatusFluentImpl that = (PersistentVolumeClaimStatusFluentImpl) o;
    if (accessModes != null ? !accessModes.equals(that.accessModes) :that.accessModes != null) return false;
    if (capacity != null ? !capacity.equals(that.capacity) :that.capacity != null) return false;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (phase != null ? !phase.equals(that.phase) :that.phase != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(accessModes,  capacity,  conditions,  phase,  super.hashCode());
  }
  public class ConditionsNestedImpl<N> extends io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionFluentImpl<io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatusFluent.ConditionsNested<N>> implements io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatusFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ConditionsNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.PersistentVolumeClaimCondition item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionBuilder(this);
    }
    io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) PersistentVolumeClaimStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  
}