package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class VolumeMountBuilder extends io.fabric8.kubernetes.api.model.VolumeMountFluentImpl<io.fabric8.kubernetes.api.model.VolumeMountBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.VolumeMount,io.fabric8.kubernetes.api.model.VolumeMountBuilder>{
  public VolumeMountBuilder() {
    this(false);
  }
  public VolumeMountBuilder(java.lang.Boolean validationEnabled) {
    this(new VolumeMount(), validationEnabled);
  }
  public VolumeMountBuilder(io.fabric8.kubernetes.api.model.VolumeMountFluent<?> fluent) {
    this(fluent, false);
  }
  public VolumeMountBuilder(io.fabric8.kubernetes.api.model.VolumeMountFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new VolumeMount(), validationEnabled);
  }
  public VolumeMountBuilder(io.fabric8.kubernetes.api.model.VolumeMountFluent<?> fluent,io.fabric8.kubernetes.api.model.VolumeMount instance) {
    this(fluent, instance, false);
  }
  public VolumeMountBuilder(io.fabric8.kubernetes.api.model.VolumeMountFluent<?> fluent,io.fabric8.kubernetes.api.model.VolumeMount instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withMountPath(instance.getMountPath()); 
    fluent.withMountPropagation(instance.getMountPropagation()); 
    fluent.withName(instance.getName()); 
    fluent.withReadOnly(instance.getReadOnly()); 
    fluent.withSubPath(instance.getSubPath()); 
    fluent.withSubPathExpr(instance.getSubPathExpr()); 
    this.validationEnabled = validationEnabled; 
  }
  public VolumeMountBuilder(io.fabric8.kubernetes.api.model.VolumeMount instance) {
    this(instance,false);
  }
  public VolumeMountBuilder(io.fabric8.kubernetes.api.model.VolumeMount instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withMountPath(instance.getMountPath()); 
    this.withMountPropagation(instance.getMountPropagation()); 
    this.withName(instance.getName()); 
    this.withReadOnly(instance.getReadOnly()); 
    this.withSubPath(instance.getSubPath()); 
    this.withSubPathExpr(instance.getSubPathExpr()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.VolumeMountFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.VolumeMount build() {
    VolumeMount buildable = new VolumeMount(fluent.getMountPath(),fluent.getMountPropagation(),fluent.getName(),fluent.getReadOnly(),fluent.getSubPath(),fluent.getSubPathExpr());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    VolumeMountBuilder that = (VolumeMountBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}