/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluentImpl;
import java.util.Objects;

public class ResourceRequirementsBuilder
extends ResourceRequirementsFluentImpl<ResourceRequirementsBuilder>
implements VisitableBuilder<ResourceRequirements, ResourceRequirementsBuilder> {
    ResourceRequirementsFluent<?> fluent;
    Boolean validationEnabled;

    public ResourceRequirementsBuilder() {
        this(false);
    }

    public ResourceRequirementsBuilder(Boolean validationEnabled) {
        this(new ResourceRequirements(), validationEnabled);
    }

    public ResourceRequirementsBuilder(ResourceRequirementsFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ResourceRequirementsBuilder(ResourceRequirementsFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ResourceRequirements(), validationEnabled);
    }

    public ResourceRequirementsBuilder(ResourceRequirementsFluent<?> fluent, ResourceRequirements instance) {
        this(fluent, instance, false);
    }

    public ResourceRequirementsBuilder(ResourceRequirementsFluent<?> fluent, ResourceRequirements instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withLimits(instance.getLimits());
        fluent.withRequests(instance.getRequests());
        this.validationEnabled = validationEnabled;
    }

    public ResourceRequirementsBuilder(ResourceRequirements instance) {
        this(instance, (Boolean)false);
    }

    public ResourceRequirementsBuilder(ResourceRequirements instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withLimits(instance.getLimits());
        this.withRequests(instance.getRequests());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ResourceRequirements build() {
        ResourceRequirements buildable = new ResourceRequirements(this.fluent.getLimits(), this.fluent.getRequests());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceRequirementsBuilder that = (ResourceRequirementsBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

