package io.fabric8.kubernetes.api.builder;

import java.lang.Class;
import java.lang.Object;
import java.util.List;
import java.util.function.Predicate;
public class DelegatingVisitor<T> implements Visitor<T>{
  DelegatingVisitor(Class<T> type,io.fabric8.kubernetes.api.builder.Visitor<T> delegate) {
    this.type = type;
    this.delegate = delegate;
  }
  private final java.lang.Class<T> type;
  private final io.fabric8.kubernetes.api.builder.Visitor<T> delegate;
  public java.lang.Class<T> getType() {
    return type;
  }
  public void visit(T target) {
    delegate.visit(target);
  }
  public int order() {
    return delegate.order();
  }
  public void visit(List<Object> path,T target) {
    delegate.visit(path, target);
  }
  public <F>Predicate<java.util.List<java.lang.Object>> getRequirement() {
    return delegate.getRequirement();
  }
  
}