package io.fabric8.kubernetes.api.builder;

import java.lang.Class;
import java.lang.Object;
import java.util.List;
import java.lang.reflect.Method;
public class PathAwareTypedVisitor<V,P> extends TypedVisitor<V>{
  PathAwareTypedVisitor() {
    List<Class> args = Visitors.getTypeArguments(PathAwareTypedVisitor.class, getClass());
    if (args == null || args.isEmpty()) {
      throw new IllegalStateException("Could not determine type arguments for path aware typed visitor.");
    }
    this.type = (Class<V>) args.get(0);
    this.parentType = (Class<P>) args.get(1);
  }
  private final Class<V> type;
  private final java.lang.Class<P> parentType;
  public void visit(V element) {
    
  }
  public void visit(List<Object> path,V element) {
    visit(element);
  }
  public P getParent(java.util.List<java.lang.Object> path) {
    return path.size() - 1 >= 0 ? (P) path.get(path.size() - 1) : null;
  }
  public java.lang.Class<P> getParentType() {
    return parentType;
  }
  
}