package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class APIGroupBuilder extends APIGroupFluentImpl<APIGroupBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.APIGroup,APIGroupBuilder>{
  public APIGroupBuilder() {
    this(false);
  }
  public APIGroupBuilder(Boolean validationEnabled) {
    this(new APIGroup(), validationEnabled);
  }
  public APIGroupBuilder(APIGroupFluent<?> fluent) {
    this(fluent, false);
  }
  public APIGroupBuilder(io.fabric8.kubernetes.api.model.APIGroupFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new APIGroup(), validationEnabled);
  }
  public APIGroupBuilder(io.fabric8.kubernetes.api.model.APIGroupFluent<?> fluent,io.fabric8.kubernetes.api.model.APIGroup instance) {
    this(fluent, instance, false);
  }
  public APIGroupBuilder(io.fabric8.kubernetes.api.model.APIGroupFluent<?> fluent,io.fabric8.kubernetes.api.model.APIGroup instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withName(instance.getName()); 
    fluent.withPreferredVersion(instance.getPreferredVersion()); 
    fluent.withServerAddressByClientCIDRs(instance.getServerAddressByClientCIDRs()); 
    fluent.withVersions(instance.getVersions()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public APIGroupBuilder(io.fabric8.kubernetes.api.model.APIGroup instance) {
    this(instance,false);
  }
  public APIGroupBuilder(io.fabric8.kubernetes.api.model.APIGroup instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withName(instance.getName()); 
    this.withPreferredVersion(instance.getPreferredVersion()); 
    this.withServerAddressByClientCIDRs(instance.getServerAddressByClientCIDRs()); 
    this.withVersions(instance.getVersions()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.APIGroupFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.APIGroup build() {
    APIGroup buildable = new APIGroup(fluent.getApiVersion(),fluent.getKind(),fluent.getName(),fluent.getPreferredVersion(),fluent.getServerAddressByClientCIDRs(),fluent.getVersions());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}