package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class APIGroupListBuilder extends APIGroupListFluentImpl<APIGroupListBuilder> implements VisitableBuilder<APIGroupList,io.fabric8.kubernetes.api.model.APIGroupListBuilder>{
  public APIGroupListBuilder() {
    this(false);
  }
  public APIGroupListBuilder(Boolean validationEnabled) {
    this(new APIGroupList(), validationEnabled);
  }
  public APIGroupListBuilder(io.fabric8.kubernetes.api.model.APIGroupListFluent<?> fluent) {
    this(fluent, false);
  }
  public APIGroupListBuilder(io.fabric8.kubernetes.api.model.APIGroupListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new APIGroupList(), validationEnabled);
  }
  public APIGroupListBuilder(io.fabric8.kubernetes.api.model.APIGroupListFluent<?> fluent,io.fabric8.kubernetes.api.model.APIGroupList instance) {
    this(fluent, instance, false);
  }
  public APIGroupListBuilder(io.fabric8.kubernetes.api.model.APIGroupListFluent<?> fluent,io.fabric8.kubernetes.api.model.APIGroupList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withGroups(instance.getGroups()); 
    fluent.withKind(instance.getKind()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public APIGroupListBuilder(io.fabric8.kubernetes.api.model.APIGroupList instance) {
    this(instance,false);
  }
  public APIGroupListBuilder(io.fabric8.kubernetes.api.model.APIGroupList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withGroups(instance.getGroups()); 
    this.withKind(instance.getKind()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.APIGroupListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.APIGroupList build() {
    APIGroupList buildable = new APIGroupList(fluent.getApiVersion(),fluent.getGroups(),fluent.getKind());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}