package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class APIResourceListBuilder extends APIResourceListFluentImpl<APIResourceListBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.APIResourceList,APIResourceListBuilder>{
  public APIResourceListBuilder() {
    this(false);
  }
  public APIResourceListBuilder(Boolean validationEnabled) {
    this(new APIResourceList(), validationEnabled);
  }
  public APIResourceListBuilder(APIResourceListFluent<?> fluent) {
    this(fluent, false);
  }
  public APIResourceListBuilder(io.fabric8.kubernetes.api.model.APIResourceListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new APIResourceList(), validationEnabled);
  }
  public APIResourceListBuilder(io.fabric8.kubernetes.api.model.APIResourceListFluent<?> fluent,io.fabric8.kubernetes.api.model.APIResourceList instance) {
    this(fluent, instance, false);
  }
  public APIResourceListBuilder(io.fabric8.kubernetes.api.model.APIResourceListFluent<?> fluent,io.fabric8.kubernetes.api.model.APIResourceList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withGroupVersion(instance.getGroupVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withResources(instance.getResources()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public APIResourceListBuilder(io.fabric8.kubernetes.api.model.APIResourceList instance) {
    this(instance,false);
  }
  public APIResourceListBuilder(io.fabric8.kubernetes.api.model.APIResourceList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withGroupVersion(instance.getGroupVersion()); 
    this.withKind(instance.getKind()); 
    this.withResources(instance.getResources()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.APIResourceListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.APIResourceList build() {
    APIResourceList buildable = new APIResourceList(fluent.getApiVersion(),fluent.getGroupVersion(),fluent.getKind(),fluent.getResources());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}