package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class APIResourceListFluentImpl<A extends APIResourceListFluent<A>> extends BaseFluent<A> implements APIResourceListFluent<A>{
  public APIResourceListFluentImpl() {
  }
  public APIResourceListFluentImpl(APIResourceList instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withGroupVersion(instance.getGroupVersion()); 
    this.withKind(instance.getKind()); 
    this.withResources(instance.getResources()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String apiVersion;
  private java.lang.String groupVersion;
  private java.lang.String kind;
  private ArrayList<APIResourceBuilder> resources = new java.util.ArrayList<io.fabric8.kubernetes.api.model.APIResourceBuilder>();
  private Map<java.lang.String,Object> additionalProperties;
  public java.lang.String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(java.lang.String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public java.lang.String getGroupVersion() {
    return this.groupVersion;
  }
  public A withGroupVersion(java.lang.String groupVersion) {
    this.groupVersion=groupVersion; return (A) this;
  }
  public java.lang.Boolean hasGroupVersion() {
    return this.groupVersion != null;
  }
  public java.lang.String getKind() {
    return this.kind;
  }
  public A withKind(java.lang.String kind) {
    this.kind=kind; return (A) this;
  }
  public java.lang.Boolean hasKind() {
    return this.kind != null;
  }
  public A addToResources(Integer index,io.fabric8.kubernetes.api.model.APIResource item) {
    if (this.resources == null) {this.resources = new java.util.ArrayList<io.fabric8.kubernetes.api.model.APIResourceBuilder>();}
    io.fabric8.kubernetes.api.model.APIResourceBuilder builder = new io.fabric8.kubernetes.api.model.APIResourceBuilder(item);_visitables.get("resources").add(index >= 0 ? index : _visitables.get("resources").size(), builder);this.resources.add(index >= 0 ? index : resources.size(), builder); return (A)this;
  }
  public A setToResources(java.lang.Integer index,io.fabric8.kubernetes.api.model.APIResource item) {
    if (this.resources == null) {this.resources = new java.util.ArrayList<io.fabric8.kubernetes.api.model.APIResourceBuilder>();}
    io.fabric8.kubernetes.api.model.APIResourceBuilder builder = new io.fabric8.kubernetes.api.model.APIResourceBuilder(item);
    if (index < 0 || index >= _visitables.get("resources").size()) { _visitables.get("resources").add(builder); } else { _visitables.get("resources").set(index, builder);}
    if (index < 0 || index >= resources.size()) { resources.add(builder); } else { resources.set(index, builder);}
     return (A)this;
  }
  public A addToResources(io.fabric8.kubernetes.api.model.APIResource... items) {
    if (this.resources == null) {this.resources = new java.util.ArrayList<io.fabric8.kubernetes.api.model.APIResourceBuilder>();}
    for (io.fabric8.kubernetes.api.model.APIResource item : items) {io.fabric8.kubernetes.api.model.APIResourceBuilder builder = new io.fabric8.kubernetes.api.model.APIResourceBuilder(item);_visitables.get("resources").add(builder);this.resources.add(builder);} return (A)this;
  }
  public A addAllToResources(Collection<io.fabric8.kubernetes.api.model.APIResource> items) {
    if (this.resources == null) {this.resources = new java.util.ArrayList<io.fabric8.kubernetes.api.model.APIResourceBuilder>();}
    for (io.fabric8.kubernetes.api.model.APIResource item : items) {io.fabric8.kubernetes.api.model.APIResourceBuilder builder = new io.fabric8.kubernetes.api.model.APIResourceBuilder(item);_visitables.get("resources").add(builder);this.resources.add(builder);} return (A)this;
  }
  public A removeFromResources(io.fabric8.kubernetes.api.model.APIResource... items) {
    for (io.fabric8.kubernetes.api.model.APIResource item : items) {io.fabric8.kubernetes.api.model.APIResourceBuilder builder = new io.fabric8.kubernetes.api.model.APIResourceBuilder(item);_visitables.get("resources").remove(builder);if (this.resources != null) {this.resources.remove(builder);}} return (A)this;
  }
  public A removeAllFromResources(java.util.Collection<io.fabric8.kubernetes.api.model.APIResource> items) {
    for (io.fabric8.kubernetes.api.model.APIResource item : items) {io.fabric8.kubernetes.api.model.APIResourceBuilder builder = new io.fabric8.kubernetes.api.model.APIResourceBuilder(item);_visitables.get("resources").remove(builder);if (this.resources != null) {this.resources.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromResources(Predicate<io.fabric8.kubernetes.api.model.APIResourceBuilder> predicate) {
    if (resources == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.APIResourceBuilder> each = resources.iterator();
    final List visitables = _visitables.get("resources");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.APIResourceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildResources instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<io.fabric8.kubernetes.api.model.APIResource> getResources() {
    return resources != null ? build(resources) : null;
  }
  public java.util.List<io.fabric8.kubernetes.api.model.APIResource> buildResources() {
    return resources != null ? build(resources) : null;
  }
  public io.fabric8.kubernetes.api.model.APIResource buildResource(java.lang.Integer index) {
    return this.resources.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.APIResource buildFirstResource() {
    return this.resources.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.APIResource buildLastResource() {
    return this.resources.get(resources.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.APIResource buildMatchingResource(java.util.function.Predicate<io.fabric8.kubernetes.api.model.APIResourceBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.APIResourceBuilder item: resources) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingResource(java.util.function.Predicate<io.fabric8.kubernetes.api.model.APIResourceBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.APIResourceBuilder item: resources) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withResources(java.util.List<io.fabric8.kubernetes.api.model.APIResource> resources) {
    if (this.resources != null) { _visitables.get("resources").removeAll(this.resources);}
    if (resources != null) {this.resources = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.APIResource item : resources){this.addToResources(item);}} else { this.resources = null;} return (A) this;
  }
  public A withResources(io.fabric8.kubernetes.api.model.APIResource... resources) {
    if (this.resources != null) {this.resources.clear();}
    if (resources != null) {for (io.fabric8.kubernetes.api.model.APIResource item :resources){ this.addToResources(item);}} return (A) this;
  }
  public java.lang.Boolean hasResources() {
    return resources != null && !resources.isEmpty();
  }
  public APIResourceListFluent.ResourcesNested<A> addNewResource() {
    return new APIResourceListFluentImpl.ResourcesNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.APIResourceListFluent.ResourcesNested<A> addNewResourceLike(io.fabric8.kubernetes.api.model.APIResource item) {
    return new APIResourceListFluentImpl.ResourcesNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.APIResourceListFluent.ResourcesNested<A> setNewResourceLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.APIResource item) {
    return new io.fabric8.kubernetes.api.model.APIResourceListFluentImpl.ResourcesNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.APIResourceListFluent.ResourcesNested<A> editResource(java.lang.Integer index) {
    if (resources.size() <= index) throw new RuntimeException("Can't edit resources. Index exceeds size.");
    return setNewResourceLike(index, buildResource(index));
  }
  public io.fabric8.kubernetes.api.model.APIResourceListFluent.ResourcesNested<A> editFirstResource() {
    if (resources.size() == 0) throw new RuntimeException("Can't edit first resources. The list is empty.");
    return setNewResourceLike(0, buildResource(0));
  }
  public io.fabric8.kubernetes.api.model.APIResourceListFluent.ResourcesNested<A> editLastResource() {
    int index = resources.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last resources. The list is empty.");
    return setNewResourceLike(index, buildResource(index));
  }
  public io.fabric8.kubernetes.api.model.APIResourceListFluent.ResourcesNested<A> editMatchingResource(java.util.function.Predicate<io.fabric8.kubernetes.api.model.APIResourceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<resources.size();i++) { 
    if (predicate.test(resources.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching resources. No match found.");
    return setNewResourceLike(index, buildResource(index));
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    APIResourceListFluentImpl that = (APIResourceListFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (groupVersion != null ? !groupVersion.equals(that.groupVersion) :that.groupVersion != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  groupVersion,  kind,  resources,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (groupVersion != null) { sb.append("groupVersion:"); sb.append(groupVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (resources != null && !resources.isEmpty()) { sb.append("resources:"); sb.append(resources + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ResourcesNestedImpl<N> extends APIResourceFluentImpl<APIResourceListFluent.ResourcesNested<N>> implements io.fabric8.kubernetes.api.model.APIResourceListFluent.ResourcesNested<N>,Nested<N>{
    ResourcesNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.APIResource item) {
      this.index = index;
      this.builder = new APIResourceBuilder(this, item);
    }
    ResourcesNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.APIResourceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.APIResourceBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) APIResourceListFluentImpl.this.setToResources(index,builder.build());
    }
    public N endResource() {
      return and();
    }
    
  }
  
}