package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class APIServiceBuilder extends APIServiceFluentImpl<APIServiceBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.APIService,APIServiceBuilder>{
  public APIServiceBuilder() {
    this(false);
  }
  public APIServiceBuilder(Boolean validationEnabled) {
    this(new APIService(), validationEnabled);
  }
  public APIServiceBuilder(APIServiceFluent<?> fluent) {
    this(fluent, false);
  }
  public APIServiceBuilder(io.fabric8.kubernetes.api.model.APIServiceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new APIService(), validationEnabled);
  }
  public APIServiceBuilder(io.fabric8.kubernetes.api.model.APIServiceFluent<?> fluent,io.fabric8.kubernetes.api.model.APIService instance) {
    this(fluent, instance, false);
  }
  public APIServiceBuilder(io.fabric8.kubernetes.api.model.APIServiceFluent<?> fluent,io.fabric8.kubernetes.api.model.APIService instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public APIServiceBuilder(io.fabric8.kubernetes.api.model.APIService instance) {
    this(instance,false);
  }
  public APIServiceBuilder(io.fabric8.kubernetes.api.model.APIService instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.APIServiceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.APIService build() {
    APIService buildable = new APIService(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}