package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class APIServiceListBuilder extends APIServiceListFluentImpl<APIServiceListBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.APIServiceList,io.fabric8.kubernetes.api.model.APIServiceListBuilder>{
  public APIServiceListBuilder() {
    this(false);
  }
  public APIServiceListBuilder(Boolean validationEnabled) {
    this(new APIServiceList(), validationEnabled);
  }
  public APIServiceListBuilder(APIServiceListFluent<?> fluent) {
    this(fluent, false);
  }
  public APIServiceListBuilder(io.fabric8.kubernetes.api.model.APIServiceListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new APIServiceList(), validationEnabled);
  }
  public APIServiceListBuilder(io.fabric8.kubernetes.api.model.APIServiceListFluent<?> fluent,io.fabric8.kubernetes.api.model.APIServiceList instance) {
    this(fluent, instance, false);
  }
  public APIServiceListBuilder(io.fabric8.kubernetes.api.model.APIServiceListFluent<?> fluent,io.fabric8.kubernetes.api.model.APIServiceList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public APIServiceListBuilder(io.fabric8.kubernetes.api.model.APIServiceList instance) {
    this(instance,false);
  }
  public APIServiceListBuilder(io.fabric8.kubernetes.api.model.APIServiceList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.APIServiceListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.APIServiceList build() {
    APIServiceList buildable = new APIServiceList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}