package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class APIServiceStatusBuilder extends APIServiceStatusFluentImpl<APIServiceStatusBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.APIServiceStatus,APIServiceStatusBuilder>{
  public APIServiceStatusBuilder() {
    this(false);
  }
  public APIServiceStatusBuilder(Boolean validationEnabled) {
    this(new APIServiceStatus(), validationEnabled);
  }
  public APIServiceStatusBuilder(io.fabric8.kubernetes.api.model.APIServiceStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public APIServiceStatusBuilder(io.fabric8.kubernetes.api.model.APIServiceStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new APIServiceStatus(), validationEnabled);
  }
  public APIServiceStatusBuilder(io.fabric8.kubernetes.api.model.APIServiceStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.APIServiceStatus instance) {
    this(fluent, instance, false);
  }
  public APIServiceStatusBuilder(io.fabric8.kubernetes.api.model.APIServiceStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.APIServiceStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withConditions(instance.getConditions()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public APIServiceStatusBuilder(io.fabric8.kubernetes.api.model.APIServiceStatus instance) {
    this(instance,false);
  }
  public APIServiceStatusBuilder(io.fabric8.kubernetes.api.model.APIServiceStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withConditions(instance.getConditions()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.APIServiceStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.APIServiceStatus build() {
    APIServiceStatus buildable = new APIServiceStatus(fluent.getConditions());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}