package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AffinityBuilder extends AffinityFluentImpl<AffinityBuilder> implements VisitableBuilder<Affinity,io.fabric8.kubernetes.api.model.AffinityBuilder>{
  public AffinityBuilder() {
    this(false);
  }
  public AffinityBuilder(Boolean validationEnabled) {
    this(new Affinity(), validationEnabled);
  }
  public AffinityBuilder(AffinityFluent<?> fluent) {
    this(fluent, false);
  }
  public AffinityBuilder(io.fabric8.kubernetes.api.model.AffinityFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Affinity(), validationEnabled);
  }
  public AffinityBuilder(io.fabric8.kubernetes.api.model.AffinityFluent<?> fluent,io.fabric8.kubernetes.api.model.Affinity instance) {
    this(fluent, instance, false);
  }
  public AffinityBuilder(io.fabric8.kubernetes.api.model.AffinityFluent<?> fluent,io.fabric8.kubernetes.api.model.Affinity instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withNodeAffinity(instance.getNodeAffinity()); 
    fluent.withPodAffinity(instance.getPodAffinity()); 
    fluent.withPodAntiAffinity(instance.getPodAntiAffinity()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public AffinityBuilder(io.fabric8.kubernetes.api.model.Affinity instance) {
    this(instance,false);
  }
  public AffinityBuilder(io.fabric8.kubernetes.api.model.Affinity instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withNodeAffinity(instance.getNodeAffinity()); 
    this.withPodAffinity(instance.getPodAffinity()); 
    this.withPodAntiAffinity(instance.getPodAntiAffinity()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.AffinityFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.Affinity build() {
    Affinity buildable = new Affinity(fluent.getNodeAffinity(),fluent.getPodAffinity(),fluent.getPodAntiAffinity());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}