package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AttachedVolumeBuilder extends AttachedVolumeFluentImpl<AttachedVolumeBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.AttachedVolume,io.fabric8.kubernetes.api.model.AttachedVolumeBuilder>{
  public AttachedVolumeBuilder() {
    this(false);
  }
  public AttachedVolumeBuilder(Boolean validationEnabled) {
    this(new AttachedVolume(), validationEnabled);
  }
  public AttachedVolumeBuilder(AttachedVolumeFluent<?> fluent) {
    this(fluent, false);
  }
  public AttachedVolumeBuilder(io.fabric8.kubernetes.api.model.AttachedVolumeFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new AttachedVolume(), validationEnabled);
  }
  public AttachedVolumeBuilder(io.fabric8.kubernetes.api.model.AttachedVolumeFluent<?> fluent,io.fabric8.kubernetes.api.model.AttachedVolume instance) {
    this(fluent, instance, false);
  }
  public AttachedVolumeBuilder(io.fabric8.kubernetes.api.model.AttachedVolumeFluent<?> fluent,io.fabric8.kubernetes.api.model.AttachedVolume instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDevicePath(instance.getDevicePath()); 
    fluent.withName(instance.getName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public AttachedVolumeBuilder(io.fabric8.kubernetes.api.model.AttachedVolume instance) {
    this(instance,false);
  }
  public AttachedVolumeBuilder(io.fabric8.kubernetes.api.model.AttachedVolume instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withDevicePath(instance.getDevicePath()); 
    this.withName(instance.getName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.AttachedVolumeFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.AttachedVolume build() {
    AttachedVolume buildable = new AttachedVolume(fluent.getDevicePath(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}