package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AuthProviderConfigBuilder extends AuthProviderConfigFluentImpl<AuthProviderConfigBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.AuthProviderConfig,AuthProviderConfigBuilder>{
  public AuthProviderConfigBuilder() {
    this(false);
  }
  public AuthProviderConfigBuilder(Boolean validationEnabled) {
    this(new AuthProviderConfig(), validationEnabled);
  }
  public AuthProviderConfigBuilder(io.fabric8.kubernetes.api.model.AuthProviderConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public AuthProviderConfigBuilder(io.fabric8.kubernetes.api.model.AuthProviderConfigFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new AuthProviderConfig(), validationEnabled);
  }
  public AuthProviderConfigBuilder(io.fabric8.kubernetes.api.model.AuthProviderConfigFluent<?> fluent,io.fabric8.kubernetes.api.model.AuthProviderConfig instance) {
    this(fluent, instance, false);
  }
  public AuthProviderConfigBuilder(io.fabric8.kubernetes.api.model.AuthProviderConfigFluent<?> fluent,io.fabric8.kubernetes.api.model.AuthProviderConfig instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withConfig(instance.getConfig()); 
    fluent.withName(instance.getName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public AuthProviderConfigBuilder(io.fabric8.kubernetes.api.model.AuthProviderConfig instance) {
    this(instance,false);
  }
  public AuthProviderConfigBuilder(io.fabric8.kubernetes.api.model.AuthProviderConfig instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withConfig(instance.getConfig()); 
    this.withName(instance.getName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.AuthProviderConfigFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.AuthProviderConfig build() {
    AuthProviderConfig buildable = new AuthProviderConfig(fluent.getConfig(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}