package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AzureDiskVolumeSourceBuilder extends AzureDiskVolumeSourceFluentImpl<AzureDiskVolumeSourceBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.AzureDiskVolumeSource,io.fabric8.kubernetes.api.model.AzureDiskVolumeSourceBuilder>{
  public AzureDiskVolumeSourceBuilder() {
    this(false);
  }
  public AzureDiskVolumeSourceBuilder(Boolean validationEnabled) {
    this(new AzureDiskVolumeSource(), validationEnabled);
  }
  public AzureDiskVolumeSourceBuilder(AzureDiskVolumeSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public AzureDiskVolumeSourceBuilder(io.fabric8.kubernetes.api.model.AzureDiskVolumeSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new AzureDiskVolumeSource(), validationEnabled);
  }
  public AzureDiskVolumeSourceBuilder(io.fabric8.kubernetes.api.model.AzureDiskVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.AzureDiskVolumeSource instance) {
    this(fluent, instance, false);
  }
  public AzureDiskVolumeSourceBuilder(io.fabric8.kubernetes.api.model.AzureDiskVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.AzureDiskVolumeSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCachingMode(instance.getCachingMode()); 
    fluent.withDiskName(instance.getDiskName()); 
    fluent.withDiskURI(instance.getDiskURI()); 
    fluent.withFsType(instance.getFsType()); 
    fluent.withKind(instance.getKind()); 
    fluent.withReadOnly(instance.getReadOnly()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public AzureDiskVolumeSourceBuilder(io.fabric8.kubernetes.api.model.AzureDiskVolumeSource instance) {
    this(instance,false);
  }
  public AzureDiskVolumeSourceBuilder(io.fabric8.kubernetes.api.model.AzureDiskVolumeSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withCachingMode(instance.getCachingMode()); 
    this.withDiskName(instance.getDiskName()); 
    this.withDiskURI(instance.getDiskURI()); 
    this.withFsType(instance.getFsType()); 
    this.withKind(instance.getKind()); 
    this.withReadOnly(instance.getReadOnly()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.AzureDiskVolumeSourceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.AzureDiskVolumeSource build() {
    AzureDiskVolumeSource buildable = new AzureDiskVolumeSource(fluent.getCachingMode(),fluent.getDiskName(),fluent.getDiskURI(),fluent.getFsType(),fluent.getKind(),fluent.getReadOnly());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}