package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AzureFileVolumeSourceBuilder extends AzureFileVolumeSourceFluentImpl<AzureFileVolumeSourceBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.AzureFileVolumeSource,io.fabric8.kubernetes.api.model.AzureFileVolumeSourceBuilder>{
  public AzureFileVolumeSourceBuilder() {
    this(false);
  }
  public AzureFileVolumeSourceBuilder(Boolean validationEnabled) {
    this(new AzureFileVolumeSource(), validationEnabled);
  }
  public AzureFileVolumeSourceBuilder(AzureFileVolumeSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public AzureFileVolumeSourceBuilder(io.fabric8.kubernetes.api.model.AzureFileVolumeSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new AzureFileVolumeSource(), validationEnabled);
  }
  public AzureFileVolumeSourceBuilder(io.fabric8.kubernetes.api.model.AzureFileVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.AzureFileVolumeSource instance) {
    this(fluent, instance, false);
  }
  public AzureFileVolumeSourceBuilder(io.fabric8.kubernetes.api.model.AzureFileVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.AzureFileVolumeSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withReadOnly(instance.getReadOnly()); 
    fluent.withSecretName(instance.getSecretName()); 
    fluent.withShareName(instance.getShareName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public AzureFileVolumeSourceBuilder(io.fabric8.kubernetes.api.model.AzureFileVolumeSource instance) {
    this(instance,false);
  }
  public AzureFileVolumeSourceBuilder(io.fabric8.kubernetes.api.model.AzureFileVolumeSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withReadOnly(instance.getReadOnly()); 
    this.withSecretName(instance.getSecretName()); 
    this.withShareName(instance.getShareName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.AzureFileVolumeSourceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.AzureFileVolumeSource build() {
    AzureFileVolumeSource buildable = new AzureFileVolumeSource(fluent.getReadOnly(),fluent.getSecretName(),fluent.getShareName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}