package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BaseKubernetesListBuilder extends BaseKubernetesListFluentImpl<BaseKubernetesListBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.BaseKubernetesList,BaseKubernetesListBuilder>{
  public BaseKubernetesListBuilder() {
    this(false);
  }
  public BaseKubernetesListBuilder(Boolean validationEnabled) {
    this(new BaseKubernetesList(), validationEnabled);
  }
  public BaseKubernetesListBuilder(BaseKubernetesListFluent<?> fluent) {
    this(fluent, false);
  }
  public BaseKubernetesListBuilder(io.fabric8.kubernetes.api.model.BaseKubernetesListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new BaseKubernetesList(), validationEnabled);
  }
  public BaseKubernetesListBuilder(io.fabric8.kubernetes.api.model.BaseKubernetesListFluent<?> fluent,io.fabric8.kubernetes.api.model.BaseKubernetesList instance) {
    this(fluent, instance, false);
  }
  public BaseKubernetesListBuilder(io.fabric8.kubernetes.api.model.BaseKubernetesListFluent<?> fluent,io.fabric8.kubernetes.api.model.BaseKubernetesList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public BaseKubernetesListBuilder(io.fabric8.kubernetes.api.model.BaseKubernetesList instance) {
    this(instance,false);
  }
  public BaseKubernetesListBuilder(io.fabric8.kubernetes.api.model.BaseKubernetesList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.BaseKubernetesListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.BaseKubernetesList build() {
    BaseKubernetesList buildable = new BaseKubernetesList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}