package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.lang.String;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Long;
import java.util.Collection;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Iterator;
import java.lang.Integer;

 /**
  * Generated
  */
public interface BaseKubernetesListFluent<A extends BaseKubernetesListFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(java.lang.String apiVersion);
  public Boolean hasApiVersion();
  public A addToItems(VisitableBuilder<? extends HasMetadata,?> builder);
  public A addToItems(Integer index,io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder);
  public A addToItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.HasMetadata item);
  public A setToItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.HasMetadata item);
  public A addToItems(io.fabric8.kubernetes.api.model.HasMetadata... items);
  public A addAllToItems(Collection<io.fabric8.kubernetes.api.model.HasMetadata> items);
  public A removeFromItems(io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder);
  public A removeFromItems(io.fabric8.kubernetes.api.model.HasMetadata... items);
  public A removeAllFromItems(java.util.Collection<io.fabric8.kubernetes.api.model.HasMetadata> items);
  
  /**
   * This method has been deprecated, please use method buildItems instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<io.fabric8.kubernetes.api.model.HasMetadata> getItems();
  public java.util.List<io.fabric8.kubernetes.api.model.HasMetadata> buildItems();
  public io.fabric8.kubernetes.api.model.HasMetadata buildItem(java.lang.Integer index);
  public io.fabric8.kubernetes.api.model.HasMetadata buildFirstItem();
  public io.fabric8.kubernetes.api.model.HasMetadata buildLastItem();
  public io.fabric8.kubernetes.api.model.HasMetadata buildMatchingItem(Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate);
  public java.lang.Boolean hasMatchingItem(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate);
  public A withItems(java.util.List<io.fabric8.kubernetes.api.model.HasMetadata> items);
  public A withItems(io.fabric8.kubernetes.api.model.HasMetadata... items);
  public java.lang.Boolean hasItems();
  public A addToLimitRangeItems(java.lang.Integer index,LimitRange item);
  public A setToLimitRangeItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.LimitRange item);
  public A addToLimitRangeItems(io.fabric8.kubernetes.api.model.LimitRange... items);
  public A addAllToLimitRangeItems(java.util.Collection<io.fabric8.kubernetes.api.model.LimitRange> items);
  public A removeFromLimitRangeItems(io.fabric8.kubernetes.api.model.LimitRange... items);
  public A removeAllFromLimitRangeItems(java.util.Collection<io.fabric8.kubernetes.api.model.LimitRange> items);
  public A removeMatchingFromLimitRangeItems(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate);
  public BaseKubernetesListFluent.LimitRangeItemsNested<A> setNewLimitRangeItemLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.LimitRange item);
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.LimitRangeItemsNested<A> addNewLimitRangeItem();
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.LimitRangeItemsNested<A> addNewLimitRangeItemLike(io.fabric8.kubernetes.api.model.LimitRange item);
  public A addToAPIServiceItems(java.lang.Integer index,APIService item);
  public A setToAPIServiceItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.APIService item);
  public A addToAPIServiceItems(io.fabric8.kubernetes.api.model.APIService... items);
  public A addAllToAPIServiceItems(java.util.Collection<io.fabric8.kubernetes.api.model.APIService> items);
  public A removeFromAPIServiceItems(io.fabric8.kubernetes.api.model.APIService... items);
  public A removeAllFromAPIServiceItems(java.util.Collection<io.fabric8.kubernetes.api.model.APIService> items);
  public A removeMatchingFromAPIServiceItems(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate);
  public BaseKubernetesListFluent.APIServiceItemsNested<A> setNewAPIServiceItemLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.APIService item);
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.APIServiceItemsNested<A> addNewAPIServiceItem();
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.APIServiceItemsNested<A> addNewAPIServiceItemLike(io.fabric8.kubernetes.api.model.APIService item);
  public A addToNamespaceItems(java.lang.Integer index,Namespace item);
  public A setToNamespaceItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.Namespace item);
  public A addToNamespaceItems(io.fabric8.kubernetes.api.model.Namespace... items);
  public A addAllToNamespaceItems(java.util.Collection<io.fabric8.kubernetes.api.model.Namespace> items);
  public A removeFromNamespaceItems(io.fabric8.kubernetes.api.model.Namespace... items);
  public A removeAllFromNamespaceItems(java.util.Collection<io.fabric8.kubernetes.api.model.Namespace> items);
  public A removeMatchingFromNamespaceItems(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate);
  public BaseKubernetesListFluent.NamespaceItemsNested<A> setNewNamespaceItemLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.Namespace item);
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.NamespaceItemsNested<A> addNewNamespaceItem();
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.NamespaceItemsNested<A> addNewNamespaceItemLike(io.fabric8.kubernetes.api.model.Namespace item);
  public A addToServiceItems(java.lang.Integer index,Service item);
  public A setToServiceItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.Service item);
  public A addToServiceItems(io.fabric8.kubernetes.api.model.Service... items);
  public A addAllToServiceItems(java.util.Collection<io.fabric8.kubernetes.api.model.Service> items);
  public A removeFromServiceItems(io.fabric8.kubernetes.api.model.Service... items);
  public A removeAllFromServiceItems(java.util.Collection<io.fabric8.kubernetes.api.model.Service> items);
  public A removeMatchingFromServiceItems(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate);
  public BaseKubernetesListFluent.ServiceItemsNested<A> setNewServiceItemLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.Service item);
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.ServiceItemsNested<A> addNewServiceItem();
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.ServiceItemsNested<A> addNewServiceItemLike(io.fabric8.kubernetes.api.model.Service item);
  public A addToReplicationControllerItems(java.lang.Integer index,ReplicationController item);
  public A setToReplicationControllerItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.ReplicationController item);
  public A addToReplicationControllerItems(io.fabric8.kubernetes.api.model.ReplicationController... items);
  public A addAllToReplicationControllerItems(java.util.Collection<io.fabric8.kubernetes.api.model.ReplicationController> items);
  public A removeFromReplicationControllerItems(io.fabric8.kubernetes.api.model.ReplicationController... items);
  public A removeAllFromReplicationControllerItems(java.util.Collection<io.fabric8.kubernetes.api.model.ReplicationController> items);
  public A removeMatchingFromReplicationControllerItems(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate);
  public BaseKubernetesListFluent.ReplicationControllerItemsNested<A> setNewReplicationControllerItemLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.ReplicationController item);
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.ReplicationControllerItemsNested<A> addNewReplicationControllerItem();
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.ReplicationControllerItemsNested<A> addNewReplicationControllerItemLike(io.fabric8.kubernetes.api.model.ReplicationController item);
  public A addToPodTemplateItems(java.lang.Integer index,PodTemplate item);
  public A setToPodTemplateItems(java.lang.Integer index,PodTemplate item);
  public A addToPodTemplateItems(io.fabric8.kubernetes.api.model.PodTemplate... items);
  public A addAllToPodTemplateItems(java.util.Collection<io.fabric8.kubernetes.api.model.PodTemplate> items);
  public A removeFromPodTemplateItems(io.fabric8.kubernetes.api.model.PodTemplate... items);
  public A removeAllFromPodTemplateItems(java.util.Collection<io.fabric8.kubernetes.api.model.PodTemplate> items);
  public A removeMatchingFromPodTemplateItems(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate);
  public BaseKubernetesListFluent.PodTemplateItemsNested<A> setNewPodTemplateItemLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.PodTemplate item);
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.PodTemplateItemsNested<A> addNewPodTemplateItem();
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.PodTemplateItemsNested<A> addNewPodTemplateItemLike(io.fabric8.kubernetes.api.model.PodTemplate item);
  public A addToEventItems(java.lang.Integer index,Event item);
  public A setToEventItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.Event item);
  public A addToEventItems(io.fabric8.kubernetes.api.model.Event... items);
  public A addAllToEventItems(java.util.Collection<io.fabric8.kubernetes.api.model.Event> items);
  public A removeFromEventItems(io.fabric8.kubernetes.api.model.Event... items);
  public A removeAllFromEventItems(java.util.Collection<io.fabric8.kubernetes.api.model.Event> items);
  public A removeMatchingFromEventItems(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate);
  public BaseKubernetesListFluent.EventItemsNested<A> setNewEventItemLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.Event item);
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.EventItemsNested<A> addNewEventItem();
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.EventItemsNested<A> addNewEventItemLike(io.fabric8.kubernetes.api.model.Event item);
  public A addToPersistentVolumeItems(java.lang.Integer index,PersistentVolume item);
  public A setToPersistentVolumeItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.PersistentVolume item);
  public A addToPersistentVolumeItems(io.fabric8.kubernetes.api.model.PersistentVolume... items);
  public A addAllToPersistentVolumeItems(java.util.Collection<io.fabric8.kubernetes.api.model.PersistentVolume> items);
  public A removeFromPersistentVolumeItems(io.fabric8.kubernetes.api.model.PersistentVolume... items);
  public A removeAllFromPersistentVolumeItems(java.util.Collection<io.fabric8.kubernetes.api.model.PersistentVolume> items);
  public A removeMatchingFromPersistentVolumeItems(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate);
  public BaseKubernetesListFluent.PersistentVolumeItemsNested<A> setNewPersistentVolumeItemLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.PersistentVolume item);
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.PersistentVolumeItemsNested<A> addNewPersistentVolumeItem();
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.PersistentVolumeItemsNested<A> addNewPersistentVolumeItemLike(io.fabric8.kubernetes.api.model.PersistentVolume item);
  public A addToPersistentVolumeClaimItems(java.lang.Integer index,PersistentVolumeClaim item);
  public A setToPersistentVolumeClaimItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.PersistentVolumeClaim item);
  public A addToPersistentVolumeClaimItems(io.fabric8.kubernetes.api.model.PersistentVolumeClaim... items);
  public A addAllToPersistentVolumeClaimItems(java.util.Collection<io.fabric8.kubernetes.api.model.PersistentVolumeClaim> items);
  public A removeFromPersistentVolumeClaimItems(io.fabric8.kubernetes.api.model.PersistentVolumeClaim... items);
  public A removeAllFromPersistentVolumeClaimItems(java.util.Collection<io.fabric8.kubernetes.api.model.PersistentVolumeClaim> items);
  public A removeMatchingFromPersistentVolumeClaimItems(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate);
  public BaseKubernetesListFluent.PersistentVolumeClaimItemsNested<A> setNewPersistentVolumeClaimItemLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.PersistentVolumeClaim item);
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.PersistentVolumeClaimItemsNested<A> addNewPersistentVolumeClaimItem();
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.PersistentVolumeClaimItemsNested<A> addNewPersistentVolumeClaimItemLike(io.fabric8.kubernetes.api.model.PersistentVolumeClaim item);
  public A addToGenericKubernetesResourceItems(java.lang.Integer index,GenericKubernetesResource item);
  public A setToGenericKubernetesResourceItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.GenericKubernetesResource item);
  public A addToGenericKubernetesResourceItems(io.fabric8.kubernetes.api.model.GenericKubernetesResource... items);
  public A addAllToGenericKubernetesResourceItems(java.util.Collection<io.fabric8.kubernetes.api.model.GenericKubernetesResource> items);
  public A removeFromGenericKubernetesResourceItems(io.fabric8.kubernetes.api.model.GenericKubernetesResource... items);
  public A removeAllFromGenericKubernetesResourceItems(java.util.Collection<io.fabric8.kubernetes.api.model.GenericKubernetesResource> items);
  public A removeMatchingFromGenericKubernetesResourceItems(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate);
  public BaseKubernetesListFluent.GenericKubernetesResourceItemsNested<A> setNewGenericKubernetesResourceItemLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.GenericKubernetesResource item);
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.GenericKubernetesResourceItemsNested<A> addNewGenericKubernetesResourceItem();
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.GenericKubernetesResourceItemsNested<A> addNewGenericKubernetesResourceItemLike(io.fabric8.kubernetes.api.model.GenericKubernetesResource item);
  public A addToEndpointsItems(java.lang.Integer index,Endpoints item);
  public A setToEndpointsItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.Endpoints item);
  public A addToEndpointsItems(io.fabric8.kubernetes.api.model.Endpoints... items);
  public A addAllToEndpointsItems(java.util.Collection<io.fabric8.kubernetes.api.model.Endpoints> items);
  public A removeFromEndpointsItems(io.fabric8.kubernetes.api.model.Endpoints... items);
  public A removeAllFromEndpointsItems(java.util.Collection<io.fabric8.kubernetes.api.model.Endpoints> items);
  public A removeMatchingFromEndpointsItems(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate);
  public BaseKubernetesListFluent.EndpointsItemsNested<A> setNewEndpointsItemLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.Endpoints item);
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.EndpointsItemsNested<A> addNewEndpointsItem();
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.EndpointsItemsNested<A> addNewEndpointsItemLike(io.fabric8.kubernetes.api.model.Endpoints item);
  public A addToPodItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.Pod item);
  public A setToPodItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.Pod item);
  public A addToPodItems(io.fabric8.kubernetes.api.model.Pod... items);
  public A addAllToPodItems(java.util.Collection<io.fabric8.kubernetes.api.model.Pod> items);
  public A removeFromPodItems(io.fabric8.kubernetes.api.model.Pod... items);
  public A removeAllFromPodItems(java.util.Collection<io.fabric8.kubernetes.api.model.Pod> items);
  public A removeMatchingFromPodItems(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate);
  public BaseKubernetesListFluent.PodItemsNested<A> setNewPodItemLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.Pod item);
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.PodItemsNested<A> addNewPodItem();
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.PodItemsNested<A> addNewPodItemLike(io.fabric8.kubernetes.api.model.Pod item);
  public A addToConfigMapItems(java.lang.Integer index,ConfigMap item);
  public A setToConfigMapItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.ConfigMap item);
  public A addToConfigMapItems(io.fabric8.kubernetes.api.model.ConfigMap... items);
  public A addAllToConfigMapItems(java.util.Collection<io.fabric8.kubernetes.api.model.ConfigMap> items);
  public A removeFromConfigMapItems(io.fabric8.kubernetes.api.model.ConfigMap... items);
  public A removeAllFromConfigMapItems(java.util.Collection<io.fabric8.kubernetes.api.model.ConfigMap> items);
  public A removeMatchingFromConfigMapItems(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate);
  public BaseKubernetesListFluent.ConfigMapItemsNested<A> setNewConfigMapItemLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.ConfigMap item);
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.ConfigMapItemsNested<A> addNewConfigMapItem();
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.ConfigMapItemsNested<A> addNewConfigMapItemLike(io.fabric8.kubernetes.api.model.ConfigMap item);
  public A addToComponentStatusItems(java.lang.Integer index,ComponentStatus item);
  public A setToComponentStatusItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.ComponentStatus item);
  public A addToComponentStatusItems(io.fabric8.kubernetes.api.model.ComponentStatus... items);
  public A addAllToComponentStatusItems(java.util.Collection<io.fabric8.kubernetes.api.model.ComponentStatus> items);
  public A removeFromComponentStatusItems(io.fabric8.kubernetes.api.model.ComponentStatus... items);
  public A removeAllFromComponentStatusItems(java.util.Collection<io.fabric8.kubernetes.api.model.ComponentStatus> items);
  public A removeMatchingFromComponentStatusItems(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate);
  public BaseKubernetesListFluent.ComponentStatusItemsNested<A> setNewComponentStatusItemLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.ComponentStatus item);
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.ComponentStatusItemsNested<A> addNewComponentStatusItem();
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.ComponentStatusItemsNested<A> addNewComponentStatusItemLike(io.fabric8.kubernetes.api.model.ComponentStatus item);
  public A addToBindingItems(java.lang.Integer index,Binding item);
  public A setToBindingItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.Binding item);
  public A addToBindingItems(io.fabric8.kubernetes.api.model.Binding... items);
  public A addAllToBindingItems(java.util.Collection<io.fabric8.kubernetes.api.model.Binding> items);
  public A removeFromBindingItems(io.fabric8.kubernetes.api.model.Binding... items);
  public A removeAllFromBindingItems(java.util.Collection<io.fabric8.kubernetes.api.model.Binding> items);
  public A removeMatchingFromBindingItems(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate);
  public BaseKubernetesListFluent.BindingItemsNested<A> setNewBindingItemLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.Binding item);
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.BindingItemsNested<A> addNewBindingItem();
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.BindingItemsNested<A> addNewBindingItemLike(io.fabric8.kubernetes.api.model.Binding item);
  public A addToResourceQuotaItems(java.lang.Integer index,ResourceQuota item);
  public A setToResourceQuotaItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.ResourceQuota item);
  public A addToResourceQuotaItems(io.fabric8.kubernetes.api.model.ResourceQuota... items);
  public A addAllToResourceQuotaItems(java.util.Collection<io.fabric8.kubernetes.api.model.ResourceQuota> items);
  public A removeFromResourceQuotaItems(io.fabric8.kubernetes.api.model.ResourceQuota... items);
  public A removeAllFromResourceQuotaItems(java.util.Collection<io.fabric8.kubernetes.api.model.ResourceQuota> items);
  public A removeMatchingFromResourceQuotaItems(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate);
  public BaseKubernetesListFluent.ResourceQuotaItemsNested<A> setNewResourceQuotaItemLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.ResourceQuota item);
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.ResourceQuotaItemsNested<A> addNewResourceQuotaItem();
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.ResourceQuotaItemsNested<A> addNewResourceQuotaItemLike(io.fabric8.kubernetes.api.model.ResourceQuota item);
  public A addToSecretItems(java.lang.Integer index,Secret item);
  public A setToSecretItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.Secret item);
  public A addToSecretItems(io.fabric8.kubernetes.api.model.Secret... items);
  public A addAllToSecretItems(java.util.Collection<io.fabric8.kubernetes.api.model.Secret> items);
  public A removeFromSecretItems(io.fabric8.kubernetes.api.model.Secret... items);
  public A removeAllFromSecretItems(java.util.Collection<io.fabric8.kubernetes.api.model.Secret> items);
  public A removeMatchingFromSecretItems(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate);
  public BaseKubernetesListFluent.SecretItemsNested<A> setNewSecretItemLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.Secret item);
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.SecretItemsNested<A> addNewSecretItem();
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.SecretItemsNested<A> addNewSecretItemLike(io.fabric8.kubernetes.api.model.Secret item);
  public A addToNodeItems(java.lang.Integer index,Node item);
  public A setToNodeItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.Node item);
  public A addToNodeItems(io.fabric8.kubernetes.api.model.Node... items);
  public A addAllToNodeItems(java.util.Collection<io.fabric8.kubernetes.api.model.Node> items);
  public A removeFromNodeItems(io.fabric8.kubernetes.api.model.Node... items);
  public A removeAllFromNodeItems(java.util.Collection<io.fabric8.kubernetes.api.model.Node> items);
  public A removeMatchingFromNodeItems(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate);
  public BaseKubernetesListFluent.NodeItemsNested<A> setNewNodeItemLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.Node item);
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.NodeItemsNested<A> addNewNodeItem();
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.NodeItemsNested<A> addNewNodeItemLike(io.fabric8.kubernetes.api.model.Node item);
  public A addToServiceAccountItems(java.lang.Integer index,ServiceAccount item);
  public A setToServiceAccountItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.ServiceAccount item);
  public A addToServiceAccountItems(io.fabric8.kubernetes.api.model.ServiceAccount... items);
  public A addAllToServiceAccountItems(java.util.Collection<io.fabric8.kubernetes.api.model.ServiceAccount> items);
  public A removeFromServiceAccountItems(io.fabric8.kubernetes.api.model.ServiceAccount... items);
  public A removeAllFromServiceAccountItems(java.util.Collection<io.fabric8.kubernetes.api.model.ServiceAccount> items);
  public A removeMatchingFromServiceAccountItems(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate);
  public BaseKubernetesListFluent.ServiceAccountItemsNested<A> setNewServiceAccountItemLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.ServiceAccount item);
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.ServiceAccountItemsNested<A> addNewServiceAccountItem();
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.ServiceAccountItemsNested<A> addNewServiceAccountItemLike(io.fabric8.kubernetes.api.model.ServiceAccount item);
  public java.lang.String getKind();
  public A withKind(java.lang.String kind);
  public java.lang.Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public ListMeta getMetadata();
  public io.fabric8.kubernetes.api.model.ListMeta buildMetadata();
  public A withMetadata(io.fabric8.kubernetes.api.model.ListMeta metadata);
  public java.lang.Boolean hasMetadata();
  public A withNewMetadata(java.lang.String _continue,Long remainingItemCount,java.lang.String resourceVersion,java.lang.String selfLink);
  public BaseKubernetesListFluent.MetadataNested<A> withNewMetadata();
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.MetadataNested<A> withNewMetadataLike(io.fabric8.kubernetes.api.model.ListMeta item);
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.MetadataNested<A> editMetadata();
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.MetadataNested<A> editOrNewMetadata();
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.MetadataNested<A> editOrNewMetadataLike(io.fabric8.kubernetes.api.model.ListMeta item);
  public A addToAdditionalProperties(java.lang.String key,Object value);
  public A addToAdditionalProperties(Map<java.lang.String,java.lang.Object> map);
  public A removeFromAdditionalProperties(java.lang.String key);
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map);
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties);
  public java.lang.Boolean hasAdditionalProperties();
  public interface LimitRangeItemsNested<N> extends Nested<N>,LimitRangeFluent<BaseKubernetesListFluent.LimitRangeItemsNested<N>>{
    public N and();
    public N endLimitRangeItem();
    
  }
  public interface APIServiceItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,APIServiceFluent<BaseKubernetesListFluent.APIServiceItemsNested<N>>{
    public N and();
    public N endAPIServiceItem();
    
  }
  public interface NamespaceItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NamespaceFluent<BaseKubernetesListFluent.NamespaceItemsNested<N>>{
    public N and();
    public N endNamespaceItem();
    
  }
  public interface ServiceItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ServiceFluent<BaseKubernetesListFluent.ServiceItemsNested<N>>{
    public N and();
    public N endServiceItem();
    
  }
  public interface ReplicationControllerItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ReplicationControllerFluent<BaseKubernetesListFluent.ReplicationControllerItemsNested<N>>{
    public N and();
    public N endReplicationControllerItem();
    
  }
  public interface PodTemplateItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PodTemplateFluent<BaseKubernetesListFluent.PodTemplateItemsNested<N>>{
    public N and();
    public N endPodTemplateItem();
    
  }
  public interface EventItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EventFluent<BaseKubernetesListFluent.EventItemsNested<N>>{
    public N and();
    public N endEventItem();
    
  }
  public interface PersistentVolumeItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PersistentVolumeFluent<BaseKubernetesListFluent.PersistentVolumeItemsNested<N>>{
    public N and();
    public N endPersistentVolumeItem();
    
  }
  public interface PersistentVolumeClaimItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PersistentVolumeClaimFluent<BaseKubernetesListFluent.PersistentVolumeClaimItemsNested<N>>{
    public N and();
    public N endPersistentVolumeClaimItem();
    
  }
  public interface GenericKubernetesResourceItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,GenericKubernetesResourceFluent<BaseKubernetesListFluent.GenericKubernetesResourceItemsNested<N>>{
    public N and();
    public N endGenericKubernetesResourceItem();
    
  }
  public interface EndpointsItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EndpointsFluent<BaseKubernetesListFluent.EndpointsItemsNested<N>>{
    public N and();
    public N endEndpointsItem();
    
  }
  public interface PodItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PodFluent<BaseKubernetesListFluent.PodItemsNested<N>>{
    public N and();
    public N endPodItem();
    
  }
  public interface ConfigMapItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ConfigMapFluent<BaseKubernetesListFluent.ConfigMapItemsNested<N>>{
    public N and();
    public N endConfigMapItem();
    
  }
  public interface ComponentStatusItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ComponentStatusFluent<BaseKubernetesListFluent.ComponentStatusItemsNested<N>>{
    public N and();
    public N endComponentStatusItem();
    
  }
  public interface BindingItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,BindingFluent<BaseKubernetesListFluent.BindingItemsNested<N>>{
    public N and();
    public N endBindingItem();
    
  }
  public interface ResourceQuotaItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ResourceQuotaFluent<BaseKubernetesListFluent.ResourceQuotaItemsNested<N>>{
    public N and();
    public N endResourceQuotaItem();
    
  }
  public interface SecretItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SecretFluent<BaseKubernetesListFluent.SecretItemsNested<N>>{
    public N and();
    public N endSecretItem();
    
  }
  public interface NodeItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NodeFluent<BaseKubernetesListFluent.NodeItemsNested<N>>{
    public N and();
    public N endNodeItem();
    
  }
  public interface ServiceAccountItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ServiceAccountFluent<BaseKubernetesListFluent.ServiceAccountItemsNested<N>>{
    public N and();
    public N endServiceAccountItem();
    
  }
  public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ListMetaFluent<BaseKubernetesListFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  
}