package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.util.List;
import java.lang.Long;
import java.util.Collection;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Iterator;
import java.lang.Integer;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class BaseKubernetesListFluentImpl<A extends BaseKubernetesListFluent<A>> extends BaseFluent<A> implements BaseKubernetesListFluent<A>{
  public BaseKubernetesListFluentImpl() {
  }
  public BaseKubernetesListFluentImpl(io.fabric8.kubernetes.api.model.BaseKubernetesList instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String apiVersion;
  private ArrayList<VisitableBuilder<? extends HasMetadata,?>> items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();
  private java.lang.String kind;
  private ListMetaBuilder metadata;
  private Map<java.lang.String,Object> additionalProperties;
  public java.lang.String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(java.lang.String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public A addToItems(io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    _visitables.get("items").add(builder);this.items.add(builder); return (A)this;
  }
  public A addToItems(Integer index,io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    _visitables.get("items").add(index, builder);this.items.add(index, builder); return (A)this;
  }
  public A addToItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.HasMetadata item) {
    if (item instanceof LimitRange){addToLimitRangeItems(index, (io.fabric8.kubernetes.api.model.LimitRange)item);}
 else if (item instanceof APIService){addToAPIServiceItems(index, (io.fabric8.kubernetes.api.model.APIService)item);}
 else if (item instanceof Namespace){addToNamespaceItems(index, (io.fabric8.kubernetes.api.model.Namespace)item);}
 else if (item instanceof Service){addToServiceItems(index, (io.fabric8.kubernetes.api.model.Service)item);}
 else if (item instanceof ReplicationController){addToReplicationControllerItems(index, (io.fabric8.kubernetes.api.model.ReplicationController)item);}
 else if (item instanceof PodTemplate){addToPodTemplateItems(index, (PodTemplate)item);}
 else if (item instanceof Event){addToEventItems(index, (io.fabric8.kubernetes.api.model.Event)item);}
 else if (item instanceof PersistentVolume){addToPersistentVolumeItems(index, (io.fabric8.kubernetes.api.model.PersistentVolume)item);}
 else if (item instanceof PersistentVolumeClaim){addToPersistentVolumeClaimItems(index, (io.fabric8.kubernetes.api.model.PersistentVolumeClaim)item);}
 else if (item instanceof GenericKubernetesResource){addToGenericKubernetesResourceItems(index, (io.fabric8.kubernetes.api.model.GenericKubernetesResource)item);}
 else if (item instanceof Endpoints){addToEndpointsItems(index, (io.fabric8.kubernetes.api.model.Endpoints)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.Pod){addToPodItems(index, (io.fabric8.kubernetes.api.model.Pod)item);}
 else if (item instanceof ConfigMap){addToConfigMapItems(index, (io.fabric8.kubernetes.api.model.ConfigMap)item);}
 else if (item instanceof ComponentStatus){addToComponentStatusItems(index, (io.fabric8.kubernetes.api.model.ComponentStatus)item);}
 else if (item instanceof Binding){addToBindingItems(index, (io.fabric8.kubernetes.api.model.Binding)item);}
 else if (item instanceof ResourceQuota){addToResourceQuotaItems(index, (io.fabric8.kubernetes.api.model.ResourceQuota)item);}
 else if (item instanceof Secret){addToSecretItems(index, (io.fabric8.kubernetes.api.model.Secret)item);}
 else if (item instanceof Node){addToNodeItems(index, (io.fabric8.kubernetes.api.model.Node)item);}
 else if (item instanceof ServiceAccount){addToServiceAccountItems(index, (io.fabric8.kubernetes.api.model.ServiceAccount)item);}

    return (A)this;
  }
  public A setToItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.HasMetadata item) {
    if (item instanceof io.fabric8.kubernetes.api.model.LimitRange){setToLimitRangeItems(index, (io.fabric8.kubernetes.api.model.LimitRange)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.APIService){setToAPIServiceItems(index, (io.fabric8.kubernetes.api.model.APIService)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.Namespace){setToNamespaceItems(index, (io.fabric8.kubernetes.api.model.Namespace)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.Service){setToServiceItems(index, (io.fabric8.kubernetes.api.model.Service)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.ReplicationController){setToReplicationControllerItems(index, (io.fabric8.kubernetes.api.model.ReplicationController)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.PodTemplate){setToPodTemplateItems(index, (io.fabric8.kubernetes.api.model.PodTemplate)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.Event){setToEventItems(index, (io.fabric8.kubernetes.api.model.Event)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.PersistentVolume){setToPersistentVolumeItems(index, (io.fabric8.kubernetes.api.model.PersistentVolume)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.PersistentVolumeClaim){setToPersistentVolumeClaimItems(index, (io.fabric8.kubernetes.api.model.PersistentVolumeClaim)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.GenericKubernetesResource){setToGenericKubernetesResourceItems(index, (io.fabric8.kubernetes.api.model.GenericKubernetesResource)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.Endpoints){setToEndpointsItems(index, (io.fabric8.kubernetes.api.model.Endpoints)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.Pod){setToPodItems(index, (io.fabric8.kubernetes.api.model.Pod)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.ConfigMap){setToConfigMapItems(index, (io.fabric8.kubernetes.api.model.ConfigMap)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.ComponentStatus){setToComponentStatusItems(index, (io.fabric8.kubernetes.api.model.ComponentStatus)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.Binding){setToBindingItems(index, (io.fabric8.kubernetes.api.model.Binding)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.ResourceQuota){setToResourceQuotaItems(index, (io.fabric8.kubernetes.api.model.ResourceQuota)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.Secret){setToSecretItems(index, (io.fabric8.kubernetes.api.model.Secret)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.Node){setToNodeItems(index, (io.fabric8.kubernetes.api.model.Node)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.ServiceAccount){setToServiceAccountItems(index, (io.fabric8.kubernetes.api.model.ServiceAccount)item);}

    return (A)this;
  }
  public A addToItems(io.fabric8.kubernetes.api.model.HasMetadata... items) {
     if (items != null && items.length > 0 && this.items== null) {this.items = new ArrayList<VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.kubernetes.api.model.HasMetadata item : items) { 
    if (item instanceof io.fabric8.kubernetes.api.model.LimitRange){addToLimitRangeItems((io.fabric8.kubernetes.api.model.LimitRange)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.APIService){addToAPIServiceItems((io.fabric8.kubernetes.api.model.APIService)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.Namespace){addToNamespaceItems((io.fabric8.kubernetes.api.model.Namespace)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.Service){addToServiceItems((io.fabric8.kubernetes.api.model.Service)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.ReplicationController){addToReplicationControllerItems((io.fabric8.kubernetes.api.model.ReplicationController)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.PodTemplate){addToPodTemplateItems((io.fabric8.kubernetes.api.model.PodTemplate)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.Event){addToEventItems((io.fabric8.kubernetes.api.model.Event)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.PersistentVolume){addToPersistentVolumeItems((io.fabric8.kubernetes.api.model.PersistentVolume)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.PersistentVolumeClaim){addToPersistentVolumeClaimItems((io.fabric8.kubernetes.api.model.PersistentVolumeClaim)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.GenericKubernetesResource){addToGenericKubernetesResourceItems((io.fabric8.kubernetes.api.model.GenericKubernetesResource)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.Endpoints){addToEndpointsItems((io.fabric8.kubernetes.api.model.Endpoints)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.Pod){addToPodItems((io.fabric8.kubernetes.api.model.Pod)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.ConfigMap){addToConfigMapItems((io.fabric8.kubernetes.api.model.ConfigMap)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.ComponentStatus){addToComponentStatusItems((io.fabric8.kubernetes.api.model.ComponentStatus)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.Binding){addToBindingItems((io.fabric8.kubernetes.api.model.Binding)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.ResourceQuota){addToResourceQuotaItems((io.fabric8.kubernetes.api.model.ResourceQuota)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.Secret){addToSecretItems((io.fabric8.kubernetes.api.model.Secret)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.Node){addToNodeItems((io.fabric8.kubernetes.api.model.Node)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.ServiceAccount){addToServiceAccountItems((io.fabric8.kubernetes.api.model.ServiceAccount)item);}

    else {  VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = builderOf(item); _visitables.get("items").add(builder);this.items.add(builder); }
    } return (A)this;
  }
  public A addAllToItems(Collection<io.fabric8.kubernetes.api.model.HasMetadata> items) {
     if (items != null && items.size() > 0 && this.items== null) {this.items = new ArrayList<VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.kubernetes.api.model.HasMetadata item : items) { 
    if (item instanceof io.fabric8.kubernetes.api.model.LimitRange){addToLimitRangeItems((io.fabric8.kubernetes.api.model.LimitRange)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.APIService){addToAPIServiceItems((io.fabric8.kubernetes.api.model.APIService)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.Namespace){addToNamespaceItems((io.fabric8.kubernetes.api.model.Namespace)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.Service){addToServiceItems((io.fabric8.kubernetes.api.model.Service)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.ReplicationController){addToReplicationControllerItems((io.fabric8.kubernetes.api.model.ReplicationController)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.PodTemplate){addToPodTemplateItems((io.fabric8.kubernetes.api.model.PodTemplate)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.Event){addToEventItems((io.fabric8.kubernetes.api.model.Event)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.PersistentVolume){addToPersistentVolumeItems((io.fabric8.kubernetes.api.model.PersistentVolume)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.PersistentVolumeClaim){addToPersistentVolumeClaimItems((io.fabric8.kubernetes.api.model.PersistentVolumeClaim)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.GenericKubernetesResource){addToGenericKubernetesResourceItems((io.fabric8.kubernetes.api.model.GenericKubernetesResource)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.Endpoints){addToEndpointsItems((io.fabric8.kubernetes.api.model.Endpoints)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.Pod){addToPodItems((io.fabric8.kubernetes.api.model.Pod)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.ConfigMap){addToConfigMapItems((io.fabric8.kubernetes.api.model.ConfigMap)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.ComponentStatus){addToComponentStatusItems((io.fabric8.kubernetes.api.model.ComponentStatus)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.Binding){addToBindingItems((io.fabric8.kubernetes.api.model.Binding)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.ResourceQuota){addToResourceQuotaItems((io.fabric8.kubernetes.api.model.ResourceQuota)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.Secret){addToSecretItems((io.fabric8.kubernetes.api.model.Secret)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.Node){addToNodeItems((io.fabric8.kubernetes.api.model.Node)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.ServiceAccount){addToServiceAccountItems((io.fabric8.kubernetes.api.model.ServiceAccount)item);}

    else {  VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = builderOf(item); _visitables.get("items").add(builder);this.items.add(builder); }
    } return (A)this;
  }
  public A removeFromItems(io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    _visitables.get("items").remove(builder);this.items.remove(builder); return (A)this;
  }
  public A removeFromItems(io.fabric8.kubernetes.api.model.HasMetadata... items) {
    for (io.fabric8.kubernetes.api.model.HasMetadata item : items) {if (item instanceof io.fabric8.kubernetes.api.model.LimitRange){removeFromLimitRangeItems((io.fabric8.kubernetes.api.model.LimitRange)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.APIService){removeFromAPIServiceItems((io.fabric8.kubernetes.api.model.APIService)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.Namespace){removeFromNamespaceItems((io.fabric8.kubernetes.api.model.Namespace)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.Service){removeFromServiceItems((io.fabric8.kubernetes.api.model.Service)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.ReplicationController){removeFromReplicationControllerItems((io.fabric8.kubernetes.api.model.ReplicationController)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.PodTemplate){removeFromPodTemplateItems((io.fabric8.kubernetes.api.model.PodTemplate)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.Event){removeFromEventItems((io.fabric8.kubernetes.api.model.Event)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.PersistentVolume){removeFromPersistentVolumeItems((io.fabric8.kubernetes.api.model.PersistentVolume)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.PersistentVolumeClaim){removeFromPersistentVolumeClaimItems((io.fabric8.kubernetes.api.model.PersistentVolumeClaim)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.GenericKubernetesResource){removeFromGenericKubernetesResourceItems((io.fabric8.kubernetes.api.model.GenericKubernetesResource)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.Endpoints){removeFromEndpointsItems((io.fabric8.kubernetes.api.model.Endpoints)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.Pod){removeFromPodItems((io.fabric8.kubernetes.api.model.Pod)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.ConfigMap){removeFromConfigMapItems((io.fabric8.kubernetes.api.model.ConfigMap)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.ComponentStatus){removeFromComponentStatusItems((io.fabric8.kubernetes.api.model.ComponentStatus)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.Binding){removeFromBindingItems((io.fabric8.kubernetes.api.model.Binding)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.ResourceQuota){removeFromResourceQuotaItems((io.fabric8.kubernetes.api.model.ResourceQuota)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.Secret){removeFromSecretItems((io.fabric8.kubernetes.api.model.Secret)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.Node){removeFromNodeItems((io.fabric8.kubernetes.api.model.Node)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.ServiceAccount){removeFromServiceAccountItems((io.fabric8.kubernetes.api.model.ServiceAccount)item);}

    else {  VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = builderOf(item); _visitables.get("items").remove(builder);this.items.remove(builder); }
    } return (A)this;
  }
  public A removeAllFromItems(java.util.Collection<io.fabric8.kubernetes.api.model.HasMetadata> items) {
    for (io.fabric8.kubernetes.api.model.HasMetadata item : items) {if (item instanceof io.fabric8.kubernetes.api.model.LimitRange){removeFromLimitRangeItems((io.fabric8.kubernetes.api.model.LimitRange)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.APIService){removeFromAPIServiceItems((io.fabric8.kubernetes.api.model.APIService)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.Namespace){removeFromNamespaceItems((io.fabric8.kubernetes.api.model.Namespace)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.Service){removeFromServiceItems((io.fabric8.kubernetes.api.model.Service)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.ReplicationController){removeFromReplicationControllerItems((io.fabric8.kubernetes.api.model.ReplicationController)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.PodTemplate){removeFromPodTemplateItems((io.fabric8.kubernetes.api.model.PodTemplate)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.Event){removeFromEventItems((io.fabric8.kubernetes.api.model.Event)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.PersistentVolume){removeFromPersistentVolumeItems((io.fabric8.kubernetes.api.model.PersistentVolume)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.PersistentVolumeClaim){removeFromPersistentVolumeClaimItems((io.fabric8.kubernetes.api.model.PersistentVolumeClaim)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.GenericKubernetesResource){removeFromGenericKubernetesResourceItems((io.fabric8.kubernetes.api.model.GenericKubernetesResource)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.Endpoints){removeFromEndpointsItems((io.fabric8.kubernetes.api.model.Endpoints)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.Pod){removeFromPodItems((io.fabric8.kubernetes.api.model.Pod)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.ConfigMap){removeFromConfigMapItems((io.fabric8.kubernetes.api.model.ConfigMap)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.ComponentStatus){removeFromComponentStatusItems((io.fabric8.kubernetes.api.model.ComponentStatus)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.Binding){removeFromBindingItems((io.fabric8.kubernetes.api.model.Binding)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.ResourceQuota){removeFromResourceQuotaItems((io.fabric8.kubernetes.api.model.ResourceQuota)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.Secret){removeFromSecretItems((io.fabric8.kubernetes.api.model.Secret)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.Node){removeFromNodeItems((io.fabric8.kubernetes.api.model.Node)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.ServiceAccount){removeFromServiceAccountItems((io.fabric8.kubernetes.api.model.ServiceAccount)item);}

    else {  VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = builderOf(item); _visitables.get("items").remove(builder);this.items.remove(builder); }
    } return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildItems instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<io.fabric8.kubernetes.api.model.HasMetadata> getItems() {
    return build(items);
  }
  public java.util.List<io.fabric8.kubernetes.api.model.HasMetadata> buildItems() {
    return build(items);
  }
  public io.fabric8.kubernetes.api.model.HasMetadata buildItem(java.lang.Integer index) {
    return this.items.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.HasMetadata buildFirstItem() {
    return this.items.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.HasMetadata buildLastItem() {
    return this.items.get(items.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.HasMetadata buildMatchingItem(Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    for (io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> item: items) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingItem(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    for (io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> item: items) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withItems(java.util.List<io.fabric8.kubernetes.api.model.HasMetadata> items) {
    if (items != null) {this.items = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.HasMetadata item : items){this.addToItems(item);}} else { this.items = null;} return (A) this;
  }
  public A withItems(io.fabric8.kubernetes.api.model.HasMetadata... items) {
    if (this.items != null) {this.items.clear();}
    if (items != null) {for (io.fabric8.kubernetes.api.model.HasMetadata item :items){ this.addToItems(item);}} return (A) this;
  }
  public java.lang.Boolean hasItems() {
    return items != null && !items.isEmpty();
  }
  public A addToLimitRangeItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.LimitRange item) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    LimitRangeBuilder builder = new io.fabric8.kubernetes.api.model.LimitRangeBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
  }
  public A setToLimitRangeItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.LimitRange item) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.kubernetes.api.model.LimitRangeBuilder builder = new io.fabric8.kubernetes.api.model.LimitRangeBuilder(item);
    if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
    if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
     return (A)this;
  }
  public A addToLimitRangeItems(io.fabric8.kubernetes.api.model.LimitRange... items) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.kubernetes.api.model.LimitRange item : items) {io.fabric8.kubernetes.api.model.LimitRangeBuilder builder = new io.fabric8.kubernetes.api.model.LimitRangeBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToLimitRangeItems(java.util.Collection<io.fabric8.kubernetes.api.model.LimitRange> items) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.kubernetes.api.model.LimitRange item : items) {io.fabric8.kubernetes.api.model.LimitRangeBuilder builder = new io.fabric8.kubernetes.api.model.LimitRangeBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromLimitRangeItems(io.fabric8.kubernetes.api.model.LimitRange... items) {
    for (io.fabric8.kubernetes.api.model.LimitRange item : items) {io.fabric8.kubernetes.api.model.LimitRangeBuilder builder = new io.fabric8.kubernetes.api.model.LimitRangeBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromLimitRangeItems(java.util.Collection<io.fabric8.kubernetes.api.model.LimitRange> items) {
    for (io.fabric8.kubernetes.api.model.LimitRange item : items) {io.fabric8.kubernetes.api.model.LimitRangeBuilder builder = new io.fabric8.kubernetes.api.model.LimitRangeBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromLimitRangeItems(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (items == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public BaseKubernetesListFluent.LimitRangeItemsNested<A> addNewLimitRangeItem() {
    return new BaseKubernetesListFluentImpl.LimitRangeItemsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.LimitRangeItemsNested<A> addNewLimitRangeItemLike(io.fabric8.kubernetes.api.model.LimitRange item) {
    return new BaseKubernetesListFluentImpl.LimitRangeItemsNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.LimitRangeItemsNested<A> setNewLimitRangeItemLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.LimitRange item) {
    return new io.fabric8.kubernetes.api.model.BaseKubernetesListFluentImpl.LimitRangeItemsNestedImpl(index, item);
  }
  public A addToAPIServiceItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.APIService item) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    APIServiceBuilder builder = new io.fabric8.kubernetes.api.model.APIServiceBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
  }
  public A setToAPIServiceItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.APIService item) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.kubernetes.api.model.APIServiceBuilder builder = new io.fabric8.kubernetes.api.model.APIServiceBuilder(item);
    if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
    if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
     return (A)this;
  }
  public A addToAPIServiceItems(io.fabric8.kubernetes.api.model.APIService... items) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.kubernetes.api.model.APIService item : items) {io.fabric8.kubernetes.api.model.APIServiceBuilder builder = new io.fabric8.kubernetes.api.model.APIServiceBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToAPIServiceItems(java.util.Collection<io.fabric8.kubernetes.api.model.APIService> items) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.kubernetes.api.model.APIService item : items) {io.fabric8.kubernetes.api.model.APIServiceBuilder builder = new io.fabric8.kubernetes.api.model.APIServiceBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromAPIServiceItems(io.fabric8.kubernetes.api.model.APIService... items) {
    for (io.fabric8.kubernetes.api.model.APIService item : items) {io.fabric8.kubernetes.api.model.APIServiceBuilder builder = new io.fabric8.kubernetes.api.model.APIServiceBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromAPIServiceItems(java.util.Collection<io.fabric8.kubernetes.api.model.APIService> items) {
    for (io.fabric8.kubernetes.api.model.APIService item : items) {io.fabric8.kubernetes.api.model.APIServiceBuilder builder = new io.fabric8.kubernetes.api.model.APIServiceBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromAPIServiceItems(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (items == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public BaseKubernetesListFluent.APIServiceItemsNested<A> addNewAPIServiceItem() {
    return new BaseKubernetesListFluentImpl.APIServiceItemsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.APIServiceItemsNested<A> addNewAPIServiceItemLike(io.fabric8.kubernetes.api.model.APIService item) {
    return new io.fabric8.kubernetes.api.model.BaseKubernetesListFluentImpl.APIServiceItemsNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.APIServiceItemsNested<A> setNewAPIServiceItemLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.APIService item) {
    return new io.fabric8.kubernetes.api.model.BaseKubernetesListFluentImpl.APIServiceItemsNestedImpl(index, item);
  }
  public A addToNamespaceItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.Namespace item) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    NamespaceBuilder builder = new io.fabric8.kubernetes.api.model.NamespaceBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
  }
  public A setToNamespaceItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.Namespace item) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.kubernetes.api.model.NamespaceBuilder builder = new io.fabric8.kubernetes.api.model.NamespaceBuilder(item);
    if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
    if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
     return (A)this;
  }
  public A addToNamespaceItems(io.fabric8.kubernetes.api.model.Namespace... items) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.kubernetes.api.model.Namespace item : items) {io.fabric8.kubernetes.api.model.NamespaceBuilder builder = new io.fabric8.kubernetes.api.model.NamespaceBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToNamespaceItems(java.util.Collection<io.fabric8.kubernetes.api.model.Namespace> items) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.kubernetes.api.model.Namespace item : items) {io.fabric8.kubernetes.api.model.NamespaceBuilder builder = new io.fabric8.kubernetes.api.model.NamespaceBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromNamespaceItems(io.fabric8.kubernetes.api.model.Namespace... items) {
    for (io.fabric8.kubernetes.api.model.Namespace item : items) {io.fabric8.kubernetes.api.model.NamespaceBuilder builder = new io.fabric8.kubernetes.api.model.NamespaceBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromNamespaceItems(java.util.Collection<io.fabric8.kubernetes.api.model.Namespace> items) {
    for (io.fabric8.kubernetes.api.model.Namespace item : items) {io.fabric8.kubernetes.api.model.NamespaceBuilder builder = new io.fabric8.kubernetes.api.model.NamespaceBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromNamespaceItems(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (items == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public BaseKubernetesListFluent.NamespaceItemsNested<A> addNewNamespaceItem() {
    return new BaseKubernetesListFluentImpl.NamespaceItemsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.NamespaceItemsNested<A> addNewNamespaceItemLike(io.fabric8.kubernetes.api.model.Namespace item) {
    return new io.fabric8.kubernetes.api.model.BaseKubernetesListFluentImpl.NamespaceItemsNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.NamespaceItemsNested<A> setNewNamespaceItemLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.Namespace item) {
    return new io.fabric8.kubernetes.api.model.BaseKubernetesListFluentImpl.NamespaceItemsNestedImpl(index, item);
  }
  public A addToServiceItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.Service item) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    ServiceBuilder builder = new io.fabric8.kubernetes.api.model.ServiceBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
  }
  public A setToServiceItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.Service item) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.kubernetes.api.model.ServiceBuilder builder = new io.fabric8.kubernetes.api.model.ServiceBuilder(item);
    if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
    if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
     return (A)this;
  }
  public A addToServiceItems(io.fabric8.kubernetes.api.model.Service... items) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.kubernetes.api.model.Service item : items) {io.fabric8.kubernetes.api.model.ServiceBuilder builder = new io.fabric8.kubernetes.api.model.ServiceBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToServiceItems(java.util.Collection<io.fabric8.kubernetes.api.model.Service> items) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.kubernetes.api.model.Service item : items) {io.fabric8.kubernetes.api.model.ServiceBuilder builder = new io.fabric8.kubernetes.api.model.ServiceBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromServiceItems(io.fabric8.kubernetes.api.model.Service... items) {
    for (io.fabric8.kubernetes.api.model.Service item : items) {io.fabric8.kubernetes.api.model.ServiceBuilder builder = new io.fabric8.kubernetes.api.model.ServiceBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromServiceItems(java.util.Collection<io.fabric8.kubernetes.api.model.Service> items) {
    for (io.fabric8.kubernetes.api.model.Service item : items) {io.fabric8.kubernetes.api.model.ServiceBuilder builder = new io.fabric8.kubernetes.api.model.ServiceBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromServiceItems(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (items == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public BaseKubernetesListFluent.ServiceItemsNested<A> addNewServiceItem() {
    return new BaseKubernetesListFluentImpl.ServiceItemsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.ServiceItemsNested<A> addNewServiceItemLike(io.fabric8.kubernetes.api.model.Service item) {
    return new io.fabric8.kubernetes.api.model.BaseKubernetesListFluentImpl.ServiceItemsNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.ServiceItemsNested<A> setNewServiceItemLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.Service item) {
    return new io.fabric8.kubernetes.api.model.BaseKubernetesListFluentImpl.ServiceItemsNestedImpl(index, item);
  }
  public A addToReplicationControllerItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.ReplicationController item) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    ReplicationControllerBuilder builder = new io.fabric8.kubernetes.api.model.ReplicationControllerBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
  }
  public A setToReplicationControllerItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.ReplicationController item) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.kubernetes.api.model.ReplicationControllerBuilder builder = new io.fabric8.kubernetes.api.model.ReplicationControllerBuilder(item);
    if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
    if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
     return (A)this;
  }
  public A addToReplicationControllerItems(io.fabric8.kubernetes.api.model.ReplicationController... items) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.kubernetes.api.model.ReplicationController item : items) {io.fabric8.kubernetes.api.model.ReplicationControllerBuilder builder = new io.fabric8.kubernetes.api.model.ReplicationControllerBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToReplicationControllerItems(java.util.Collection<io.fabric8.kubernetes.api.model.ReplicationController> items) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.kubernetes.api.model.ReplicationController item : items) {io.fabric8.kubernetes.api.model.ReplicationControllerBuilder builder = new io.fabric8.kubernetes.api.model.ReplicationControllerBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromReplicationControllerItems(io.fabric8.kubernetes.api.model.ReplicationController... items) {
    for (io.fabric8.kubernetes.api.model.ReplicationController item : items) {io.fabric8.kubernetes.api.model.ReplicationControllerBuilder builder = new io.fabric8.kubernetes.api.model.ReplicationControllerBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromReplicationControllerItems(java.util.Collection<io.fabric8.kubernetes.api.model.ReplicationController> items) {
    for (io.fabric8.kubernetes.api.model.ReplicationController item : items) {io.fabric8.kubernetes.api.model.ReplicationControllerBuilder builder = new io.fabric8.kubernetes.api.model.ReplicationControllerBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromReplicationControllerItems(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (items == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public BaseKubernetesListFluent.ReplicationControllerItemsNested<A> addNewReplicationControllerItem() {
    return new BaseKubernetesListFluentImpl.ReplicationControllerItemsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.ReplicationControllerItemsNested<A> addNewReplicationControllerItemLike(io.fabric8.kubernetes.api.model.ReplicationController item) {
    return new io.fabric8.kubernetes.api.model.BaseKubernetesListFluentImpl.ReplicationControllerItemsNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.ReplicationControllerItemsNested<A> setNewReplicationControllerItemLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.ReplicationController item) {
    return new io.fabric8.kubernetes.api.model.BaseKubernetesListFluentImpl.ReplicationControllerItemsNestedImpl(index, item);
  }
  public A addToPodTemplateItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.PodTemplate item) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    PodTemplateBuilder builder = new io.fabric8.kubernetes.api.model.PodTemplateBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
  }
  public A setToPodTemplateItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.PodTemplate item) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.kubernetes.api.model.PodTemplateBuilder builder = new io.fabric8.kubernetes.api.model.PodTemplateBuilder(item);
    if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
    if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
     return (A)this;
  }
  public A addToPodTemplateItems(io.fabric8.kubernetes.api.model.PodTemplate... items) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.kubernetes.api.model.PodTemplate item : items) {io.fabric8.kubernetes.api.model.PodTemplateBuilder builder = new io.fabric8.kubernetes.api.model.PodTemplateBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToPodTemplateItems(java.util.Collection<io.fabric8.kubernetes.api.model.PodTemplate> items) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.kubernetes.api.model.PodTemplate item : items) {io.fabric8.kubernetes.api.model.PodTemplateBuilder builder = new io.fabric8.kubernetes.api.model.PodTemplateBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromPodTemplateItems(io.fabric8.kubernetes.api.model.PodTemplate... items) {
    for (io.fabric8.kubernetes.api.model.PodTemplate item : items) {io.fabric8.kubernetes.api.model.PodTemplateBuilder builder = new io.fabric8.kubernetes.api.model.PodTemplateBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromPodTemplateItems(java.util.Collection<io.fabric8.kubernetes.api.model.PodTemplate> items) {
    for (io.fabric8.kubernetes.api.model.PodTemplate item : items) {io.fabric8.kubernetes.api.model.PodTemplateBuilder builder = new io.fabric8.kubernetes.api.model.PodTemplateBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromPodTemplateItems(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (items == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public BaseKubernetesListFluent.PodTemplateItemsNested<A> addNewPodTemplateItem() {
    return new BaseKubernetesListFluentImpl.PodTemplateItemsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.PodTemplateItemsNested<A> addNewPodTemplateItemLike(io.fabric8.kubernetes.api.model.PodTemplate item) {
    return new io.fabric8.kubernetes.api.model.BaseKubernetesListFluentImpl.PodTemplateItemsNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.PodTemplateItemsNested<A> setNewPodTemplateItemLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.PodTemplate item) {
    return new io.fabric8.kubernetes.api.model.BaseKubernetesListFluentImpl.PodTemplateItemsNestedImpl(index, item);
  }
  public A addToEventItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.Event item) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    EventBuilder builder = new io.fabric8.kubernetes.api.model.EventBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
  }
  public A setToEventItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.Event item) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.kubernetes.api.model.EventBuilder builder = new io.fabric8.kubernetes.api.model.EventBuilder(item);
    if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
    if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
     return (A)this;
  }
  public A addToEventItems(io.fabric8.kubernetes.api.model.Event... items) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.kubernetes.api.model.Event item : items) {io.fabric8.kubernetes.api.model.EventBuilder builder = new io.fabric8.kubernetes.api.model.EventBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToEventItems(java.util.Collection<io.fabric8.kubernetes.api.model.Event> items) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.kubernetes.api.model.Event item : items) {io.fabric8.kubernetes.api.model.EventBuilder builder = new io.fabric8.kubernetes.api.model.EventBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromEventItems(io.fabric8.kubernetes.api.model.Event... items) {
    for (io.fabric8.kubernetes.api.model.Event item : items) {io.fabric8.kubernetes.api.model.EventBuilder builder = new io.fabric8.kubernetes.api.model.EventBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromEventItems(java.util.Collection<io.fabric8.kubernetes.api.model.Event> items) {
    for (io.fabric8.kubernetes.api.model.Event item : items) {io.fabric8.kubernetes.api.model.EventBuilder builder = new io.fabric8.kubernetes.api.model.EventBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromEventItems(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (items == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public BaseKubernetesListFluent.EventItemsNested<A> addNewEventItem() {
    return new BaseKubernetesListFluentImpl.EventItemsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.EventItemsNested<A> addNewEventItemLike(io.fabric8.kubernetes.api.model.Event item) {
    return new io.fabric8.kubernetes.api.model.BaseKubernetesListFluentImpl.EventItemsNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.EventItemsNested<A> setNewEventItemLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.Event item) {
    return new io.fabric8.kubernetes.api.model.BaseKubernetesListFluentImpl.EventItemsNestedImpl(index, item);
  }
  public A addToPersistentVolumeItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.PersistentVolume item) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    PersistentVolumeBuilder builder = new io.fabric8.kubernetes.api.model.PersistentVolumeBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
  }
  public A setToPersistentVolumeItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.PersistentVolume item) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.kubernetes.api.model.PersistentVolumeBuilder builder = new io.fabric8.kubernetes.api.model.PersistentVolumeBuilder(item);
    if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
    if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
     return (A)this;
  }
  public A addToPersistentVolumeItems(io.fabric8.kubernetes.api.model.PersistentVolume... items) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.kubernetes.api.model.PersistentVolume item : items) {io.fabric8.kubernetes.api.model.PersistentVolumeBuilder builder = new io.fabric8.kubernetes.api.model.PersistentVolumeBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToPersistentVolumeItems(java.util.Collection<io.fabric8.kubernetes.api.model.PersistentVolume> items) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.kubernetes.api.model.PersistentVolume item : items) {io.fabric8.kubernetes.api.model.PersistentVolumeBuilder builder = new io.fabric8.kubernetes.api.model.PersistentVolumeBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromPersistentVolumeItems(io.fabric8.kubernetes.api.model.PersistentVolume... items) {
    for (io.fabric8.kubernetes.api.model.PersistentVolume item : items) {io.fabric8.kubernetes.api.model.PersistentVolumeBuilder builder = new io.fabric8.kubernetes.api.model.PersistentVolumeBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromPersistentVolumeItems(java.util.Collection<io.fabric8.kubernetes.api.model.PersistentVolume> items) {
    for (io.fabric8.kubernetes.api.model.PersistentVolume item : items) {io.fabric8.kubernetes.api.model.PersistentVolumeBuilder builder = new io.fabric8.kubernetes.api.model.PersistentVolumeBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromPersistentVolumeItems(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (items == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public BaseKubernetesListFluent.PersistentVolumeItemsNested<A> addNewPersistentVolumeItem() {
    return new BaseKubernetesListFluentImpl.PersistentVolumeItemsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.PersistentVolumeItemsNested<A> addNewPersistentVolumeItemLike(io.fabric8.kubernetes.api.model.PersistentVolume item) {
    return new io.fabric8.kubernetes.api.model.BaseKubernetesListFluentImpl.PersistentVolumeItemsNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.PersistentVolumeItemsNested<A> setNewPersistentVolumeItemLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.PersistentVolume item) {
    return new io.fabric8.kubernetes.api.model.BaseKubernetesListFluentImpl.PersistentVolumeItemsNestedImpl(index, item);
  }
  public A addToPersistentVolumeClaimItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.PersistentVolumeClaim item) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    PersistentVolumeClaimBuilder builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
  }
  public A setToPersistentVolumeClaimItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.PersistentVolumeClaim item) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder(item);
    if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
    if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
     return (A)this;
  }
  public A addToPersistentVolumeClaimItems(io.fabric8.kubernetes.api.model.PersistentVolumeClaim... items) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.kubernetes.api.model.PersistentVolumeClaim item : items) {io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToPersistentVolumeClaimItems(java.util.Collection<io.fabric8.kubernetes.api.model.PersistentVolumeClaim> items) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.kubernetes.api.model.PersistentVolumeClaim item : items) {io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromPersistentVolumeClaimItems(io.fabric8.kubernetes.api.model.PersistentVolumeClaim... items) {
    for (io.fabric8.kubernetes.api.model.PersistentVolumeClaim item : items) {io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromPersistentVolumeClaimItems(java.util.Collection<io.fabric8.kubernetes.api.model.PersistentVolumeClaim> items) {
    for (io.fabric8.kubernetes.api.model.PersistentVolumeClaim item : items) {io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromPersistentVolumeClaimItems(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (items == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public BaseKubernetesListFluent.PersistentVolumeClaimItemsNested<A> addNewPersistentVolumeClaimItem() {
    return new BaseKubernetesListFluentImpl.PersistentVolumeClaimItemsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.PersistentVolumeClaimItemsNested<A> addNewPersistentVolumeClaimItemLike(io.fabric8.kubernetes.api.model.PersistentVolumeClaim item) {
    return new io.fabric8.kubernetes.api.model.BaseKubernetesListFluentImpl.PersistentVolumeClaimItemsNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.PersistentVolumeClaimItemsNested<A> setNewPersistentVolumeClaimItemLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.PersistentVolumeClaim item) {
    return new io.fabric8.kubernetes.api.model.BaseKubernetesListFluentImpl.PersistentVolumeClaimItemsNestedImpl(index, item);
  }
  public A addToGenericKubernetesResourceItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.GenericKubernetesResource item) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    GenericKubernetesResourceBuilder builder = new io.fabric8.kubernetes.api.model.GenericKubernetesResourceBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
  }
  public A setToGenericKubernetesResourceItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.GenericKubernetesResource item) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.kubernetes.api.model.GenericKubernetesResourceBuilder builder = new io.fabric8.kubernetes.api.model.GenericKubernetesResourceBuilder(item);
    if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
    if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
     return (A)this;
  }
  public A addToGenericKubernetesResourceItems(io.fabric8.kubernetes.api.model.GenericKubernetesResource... items) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.kubernetes.api.model.GenericKubernetesResource item : items) {io.fabric8.kubernetes.api.model.GenericKubernetesResourceBuilder builder = new io.fabric8.kubernetes.api.model.GenericKubernetesResourceBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToGenericKubernetesResourceItems(java.util.Collection<io.fabric8.kubernetes.api.model.GenericKubernetesResource> items) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.kubernetes.api.model.GenericKubernetesResource item : items) {io.fabric8.kubernetes.api.model.GenericKubernetesResourceBuilder builder = new io.fabric8.kubernetes.api.model.GenericKubernetesResourceBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromGenericKubernetesResourceItems(io.fabric8.kubernetes.api.model.GenericKubernetesResource... items) {
    for (io.fabric8.kubernetes.api.model.GenericKubernetesResource item : items) {io.fabric8.kubernetes.api.model.GenericKubernetesResourceBuilder builder = new io.fabric8.kubernetes.api.model.GenericKubernetesResourceBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromGenericKubernetesResourceItems(java.util.Collection<io.fabric8.kubernetes.api.model.GenericKubernetesResource> items) {
    for (io.fabric8.kubernetes.api.model.GenericKubernetesResource item : items) {io.fabric8.kubernetes.api.model.GenericKubernetesResourceBuilder builder = new io.fabric8.kubernetes.api.model.GenericKubernetesResourceBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromGenericKubernetesResourceItems(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (items == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public BaseKubernetesListFluent.GenericKubernetesResourceItemsNested<A> addNewGenericKubernetesResourceItem() {
    return new BaseKubernetesListFluentImpl.GenericKubernetesResourceItemsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.GenericKubernetesResourceItemsNested<A> addNewGenericKubernetesResourceItemLike(io.fabric8.kubernetes.api.model.GenericKubernetesResource item) {
    return new io.fabric8.kubernetes.api.model.BaseKubernetesListFluentImpl.GenericKubernetesResourceItemsNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.GenericKubernetesResourceItemsNested<A> setNewGenericKubernetesResourceItemLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.GenericKubernetesResource item) {
    return new io.fabric8.kubernetes.api.model.BaseKubernetesListFluentImpl.GenericKubernetesResourceItemsNestedImpl(index, item);
  }
  public A addToEndpointsItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.Endpoints item) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    EndpointsBuilder builder = new io.fabric8.kubernetes.api.model.EndpointsBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
  }
  public A setToEndpointsItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.Endpoints item) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.kubernetes.api.model.EndpointsBuilder builder = new io.fabric8.kubernetes.api.model.EndpointsBuilder(item);
    if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
    if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
     return (A)this;
  }
  public A addToEndpointsItems(io.fabric8.kubernetes.api.model.Endpoints... items) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.kubernetes.api.model.Endpoints item : items) {io.fabric8.kubernetes.api.model.EndpointsBuilder builder = new io.fabric8.kubernetes.api.model.EndpointsBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToEndpointsItems(java.util.Collection<io.fabric8.kubernetes.api.model.Endpoints> items) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.kubernetes.api.model.Endpoints item : items) {io.fabric8.kubernetes.api.model.EndpointsBuilder builder = new io.fabric8.kubernetes.api.model.EndpointsBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromEndpointsItems(io.fabric8.kubernetes.api.model.Endpoints... items) {
    for (io.fabric8.kubernetes.api.model.Endpoints item : items) {io.fabric8.kubernetes.api.model.EndpointsBuilder builder = new io.fabric8.kubernetes.api.model.EndpointsBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromEndpointsItems(java.util.Collection<io.fabric8.kubernetes.api.model.Endpoints> items) {
    for (io.fabric8.kubernetes.api.model.Endpoints item : items) {io.fabric8.kubernetes.api.model.EndpointsBuilder builder = new io.fabric8.kubernetes.api.model.EndpointsBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromEndpointsItems(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (items == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public BaseKubernetesListFluent.EndpointsItemsNested<A> addNewEndpointsItem() {
    return new BaseKubernetesListFluentImpl.EndpointsItemsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.EndpointsItemsNested<A> addNewEndpointsItemLike(io.fabric8.kubernetes.api.model.Endpoints item) {
    return new io.fabric8.kubernetes.api.model.BaseKubernetesListFluentImpl.EndpointsItemsNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.EndpointsItemsNested<A> setNewEndpointsItemLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.Endpoints item) {
    return new io.fabric8.kubernetes.api.model.BaseKubernetesListFluentImpl.EndpointsItemsNestedImpl(index, item);
  }
  public A addToPodItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.Pod item) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    PodBuilder builder = new io.fabric8.kubernetes.api.model.PodBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
  }
  public A setToPodItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.Pod item) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.kubernetes.api.model.PodBuilder builder = new io.fabric8.kubernetes.api.model.PodBuilder(item);
    if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
    if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
     return (A)this;
  }
  public A addToPodItems(io.fabric8.kubernetes.api.model.Pod... items) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.kubernetes.api.model.Pod item : items) {io.fabric8.kubernetes.api.model.PodBuilder builder = new io.fabric8.kubernetes.api.model.PodBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToPodItems(java.util.Collection<io.fabric8.kubernetes.api.model.Pod> items) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.kubernetes.api.model.Pod item : items) {io.fabric8.kubernetes.api.model.PodBuilder builder = new io.fabric8.kubernetes.api.model.PodBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromPodItems(io.fabric8.kubernetes.api.model.Pod... items) {
    for (io.fabric8.kubernetes.api.model.Pod item : items) {io.fabric8.kubernetes.api.model.PodBuilder builder = new io.fabric8.kubernetes.api.model.PodBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromPodItems(java.util.Collection<io.fabric8.kubernetes.api.model.Pod> items) {
    for (io.fabric8.kubernetes.api.model.Pod item : items) {io.fabric8.kubernetes.api.model.PodBuilder builder = new io.fabric8.kubernetes.api.model.PodBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromPodItems(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (items == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public BaseKubernetesListFluent.PodItemsNested<A> addNewPodItem() {
    return new BaseKubernetesListFluentImpl.PodItemsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.PodItemsNested<A> addNewPodItemLike(io.fabric8.kubernetes.api.model.Pod item) {
    return new io.fabric8.kubernetes.api.model.BaseKubernetesListFluentImpl.PodItemsNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.PodItemsNested<A> setNewPodItemLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.Pod item) {
    return new io.fabric8.kubernetes.api.model.BaseKubernetesListFluentImpl.PodItemsNestedImpl(index, item);
  }
  public A addToConfigMapItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.ConfigMap item) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    ConfigMapBuilder builder = new io.fabric8.kubernetes.api.model.ConfigMapBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
  }
  public A setToConfigMapItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.ConfigMap item) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.kubernetes.api.model.ConfigMapBuilder builder = new io.fabric8.kubernetes.api.model.ConfigMapBuilder(item);
    if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
    if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
     return (A)this;
  }
  public A addToConfigMapItems(io.fabric8.kubernetes.api.model.ConfigMap... items) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.kubernetes.api.model.ConfigMap item : items) {io.fabric8.kubernetes.api.model.ConfigMapBuilder builder = new io.fabric8.kubernetes.api.model.ConfigMapBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToConfigMapItems(java.util.Collection<io.fabric8.kubernetes.api.model.ConfigMap> items) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.kubernetes.api.model.ConfigMap item : items) {io.fabric8.kubernetes.api.model.ConfigMapBuilder builder = new io.fabric8.kubernetes.api.model.ConfigMapBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromConfigMapItems(io.fabric8.kubernetes.api.model.ConfigMap... items) {
    for (io.fabric8.kubernetes.api.model.ConfigMap item : items) {io.fabric8.kubernetes.api.model.ConfigMapBuilder builder = new io.fabric8.kubernetes.api.model.ConfigMapBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromConfigMapItems(java.util.Collection<io.fabric8.kubernetes.api.model.ConfigMap> items) {
    for (io.fabric8.kubernetes.api.model.ConfigMap item : items) {io.fabric8.kubernetes.api.model.ConfigMapBuilder builder = new io.fabric8.kubernetes.api.model.ConfigMapBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConfigMapItems(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (items == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public BaseKubernetesListFluent.ConfigMapItemsNested<A> addNewConfigMapItem() {
    return new BaseKubernetesListFluentImpl.ConfigMapItemsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.ConfigMapItemsNested<A> addNewConfigMapItemLike(io.fabric8.kubernetes.api.model.ConfigMap item) {
    return new io.fabric8.kubernetes.api.model.BaseKubernetesListFluentImpl.ConfigMapItemsNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.ConfigMapItemsNested<A> setNewConfigMapItemLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.ConfigMap item) {
    return new io.fabric8.kubernetes.api.model.BaseKubernetesListFluentImpl.ConfigMapItemsNestedImpl(index, item);
  }
  public A addToComponentStatusItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.ComponentStatus item) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    ComponentStatusBuilder builder = new io.fabric8.kubernetes.api.model.ComponentStatusBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
  }
  public A setToComponentStatusItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.ComponentStatus item) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.kubernetes.api.model.ComponentStatusBuilder builder = new io.fabric8.kubernetes.api.model.ComponentStatusBuilder(item);
    if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
    if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
     return (A)this;
  }
  public A addToComponentStatusItems(io.fabric8.kubernetes.api.model.ComponentStatus... items) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.kubernetes.api.model.ComponentStatus item : items) {io.fabric8.kubernetes.api.model.ComponentStatusBuilder builder = new io.fabric8.kubernetes.api.model.ComponentStatusBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToComponentStatusItems(java.util.Collection<io.fabric8.kubernetes.api.model.ComponentStatus> items) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.kubernetes.api.model.ComponentStatus item : items) {io.fabric8.kubernetes.api.model.ComponentStatusBuilder builder = new io.fabric8.kubernetes.api.model.ComponentStatusBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromComponentStatusItems(io.fabric8.kubernetes.api.model.ComponentStatus... items) {
    for (io.fabric8.kubernetes.api.model.ComponentStatus item : items) {io.fabric8.kubernetes.api.model.ComponentStatusBuilder builder = new io.fabric8.kubernetes.api.model.ComponentStatusBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromComponentStatusItems(java.util.Collection<io.fabric8.kubernetes.api.model.ComponentStatus> items) {
    for (io.fabric8.kubernetes.api.model.ComponentStatus item : items) {io.fabric8.kubernetes.api.model.ComponentStatusBuilder builder = new io.fabric8.kubernetes.api.model.ComponentStatusBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromComponentStatusItems(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (items == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public BaseKubernetesListFluent.ComponentStatusItemsNested<A> addNewComponentStatusItem() {
    return new BaseKubernetesListFluentImpl.ComponentStatusItemsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.ComponentStatusItemsNested<A> addNewComponentStatusItemLike(io.fabric8.kubernetes.api.model.ComponentStatus item) {
    return new io.fabric8.kubernetes.api.model.BaseKubernetesListFluentImpl.ComponentStatusItemsNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.ComponentStatusItemsNested<A> setNewComponentStatusItemLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.ComponentStatus item) {
    return new io.fabric8.kubernetes.api.model.BaseKubernetesListFluentImpl.ComponentStatusItemsNestedImpl(index, item);
  }
  public A addToBindingItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.Binding item) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    BindingBuilder builder = new io.fabric8.kubernetes.api.model.BindingBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
  }
  public A setToBindingItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.Binding item) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.kubernetes.api.model.BindingBuilder builder = new io.fabric8.kubernetes.api.model.BindingBuilder(item);
    if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
    if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
     return (A)this;
  }
  public A addToBindingItems(io.fabric8.kubernetes.api.model.Binding... items) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.kubernetes.api.model.Binding item : items) {io.fabric8.kubernetes.api.model.BindingBuilder builder = new io.fabric8.kubernetes.api.model.BindingBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToBindingItems(java.util.Collection<io.fabric8.kubernetes.api.model.Binding> items) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.kubernetes.api.model.Binding item : items) {io.fabric8.kubernetes.api.model.BindingBuilder builder = new io.fabric8.kubernetes.api.model.BindingBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromBindingItems(io.fabric8.kubernetes.api.model.Binding... items) {
    for (io.fabric8.kubernetes.api.model.Binding item : items) {io.fabric8.kubernetes.api.model.BindingBuilder builder = new io.fabric8.kubernetes.api.model.BindingBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromBindingItems(java.util.Collection<io.fabric8.kubernetes.api.model.Binding> items) {
    for (io.fabric8.kubernetes.api.model.Binding item : items) {io.fabric8.kubernetes.api.model.BindingBuilder builder = new io.fabric8.kubernetes.api.model.BindingBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromBindingItems(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (items == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public BaseKubernetesListFluent.BindingItemsNested<A> addNewBindingItem() {
    return new BaseKubernetesListFluentImpl.BindingItemsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.BindingItemsNested<A> addNewBindingItemLike(io.fabric8.kubernetes.api.model.Binding item) {
    return new io.fabric8.kubernetes.api.model.BaseKubernetesListFluentImpl.BindingItemsNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.BindingItemsNested<A> setNewBindingItemLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.Binding item) {
    return new io.fabric8.kubernetes.api.model.BaseKubernetesListFluentImpl.BindingItemsNestedImpl(index, item);
  }
  public A addToResourceQuotaItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.ResourceQuota item) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    ResourceQuotaBuilder builder = new io.fabric8.kubernetes.api.model.ResourceQuotaBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
  }
  public A setToResourceQuotaItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.ResourceQuota item) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.kubernetes.api.model.ResourceQuotaBuilder builder = new io.fabric8.kubernetes.api.model.ResourceQuotaBuilder(item);
    if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
    if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
     return (A)this;
  }
  public A addToResourceQuotaItems(io.fabric8.kubernetes.api.model.ResourceQuota... items) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.kubernetes.api.model.ResourceQuota item : items) {io.fabric8.kubernetes.api.model.ResourceQuotaBuilder builder = new io.fabric8.kubernetes.api.model.ResourceQuotaBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToResourceQuotaItems(java.util.Collection<io.fabric8.kubernetes.api.model.ResourceQuota> items) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.kubernetes.api.model.ResourceQuota item : items) {io.fabric8.kubernetes.api.model.ResourceQuotaBuilder builder = new io.fabric8.kubernetes.api.model.ResourceQuotaBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromResourceQuotaItems(io.fabric8.kubernetes.api.model.ResourceQuota... items) {
    for (io.fabric8.kubernetes.api.model.ResourceQuota item : items) {io.fabric8.kubernetes.api.model.ResourceQuotaBuilder builder = new io.fabric8.kubernetes.api.model.ResourceQuotaBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromResourceQuotaItems(java.util.Collection<io.fabric8.kubernetes.api.model.ResourceQuota> items) {
    for (io.fabric8.kubernetes.api.model.ResourceQuota item : items) {io.fabric8.kubernetes.api.model.ResourceQuotaBuilder builder = new io.fabric8.kubernetes.api.model.ResourceQuotaBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromResourceQuotaItems(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (items == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public BaseKubernetesListFluent.ResourceQuotaItemsNested<A> addNewResourceQuotaItem() {
    return new BaseKubernetesListFluentImpl.ResourceQuotaItemsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.ResourceQuotaItemsNested<A> addNewResourceQuotaItemLike(io.fabric8.kubernetes.api.model.ResourceQuota item) {
    return new io.fabric8.kubernetes.api.model.BaseKubernetesListFluentImpl.ResourceQuotaItemsNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.ResourceQuotaItemsNested<A> setNewResourceQuotaItemLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.ResourceQuota item) {
    return new io.fabric8.kubernetes.api.model.BaseKubernetesListFluentImpl.ResourceQuotaItemsNestedImpl(index, item);
  }
  public A addToSecretItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.Secret item) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    SecretBuilder builder = new io.fabric8.kubernetes.api.model.SecretBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
  }
  public A setToSecretItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.Secret item) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.kubernetes.api.model.SecretBuilder builder = new io.fabric8.kubernetes.api.model.SecretBuilder(item);
    if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
    if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
     return (A)this;
  }
  public A addToSecretItems(io.fabric8.kubernetes.api.model.Secret... items) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.kubernetes.api.model.Secret item : items) {io.fabric8.kubernetes.api.model.SecretBuilder builder = new io.fabric8.kubernetes.api.model.SecretBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToSecretItems(java.util.Collection<io.fabric8.kubernetes.api.model.Secret> items) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.kubernetes.api.model.Secret item : items) {io.fabric8.kubernetes.api.model.SecretBuilder builder = new io.fabric8.kubernetes.api.model.SecretBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromSecretItems(io.fabric8.kubernetes.api.model.Secret... items) {
    for (io.fabric8.kubernetes.api.model.Secret item : items) {io.fabric8.kubernetes.api.model.SecretBuilder builder = new io.fabric8.kubernetes.api.model.SecretBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromSecretItems(java.util.Collection<io.fabric8.kubernetes.api.model.Secret> items) {
    for (io.fabric8.kubernetes.api.model.Secret item : items) {io.fabric8.kubernetes.api.model.SecretBuilder builder = new io.fabric8.kubernetes.api.model.SecretBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromSecretItems(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (items == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public BaseKubernetesListFluent.SecretItemsNested<A> addNewSecretItem() {
    return new BaseKubernetesListFluentImpl.SecretItemsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.SecretItemsNested<A> addNewSecretItemLike(io.fabric8.kubernetes.api.model.Secret item) {
    return new io.fabric8.kubernetes.api.model.BaseKubernetesListFluentImpl.SecretItemsNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.SecretItemsNested<A> setNewSecretItemLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.Secret item) {
    return new io.fabric8.kubernetes.api.model.BaseKubernetesListFluentImpl.SecretItemsNestedImpl(index, item);
  }
  public A addToNodeItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.Node item) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    NodeBuilder builder = new io.fabric8.kubernetes.api.model.NodeBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
  }
  public A setToNodeItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.Node item) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.kubernetes.api.model.NodeBuilder builder = new io.fabric8.kubernetes.api.model.NodeBuilder(item);
    if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
    if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
     return (A)this;
  }
  public A addToNodeItems(io.fabric8.kubernetes.api.model.Node... items) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.kubernetes.api.model.Node item : items) {io.fabric8.kubernetes.api.model.NodeBuilder builder = new io.fabric8.kubernetes.api.model.NodeBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToNodeItems(java.util.Collection<io.fabric8.kubernetes.api.model.Node> items) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.kubernetes.api.model.Node item : items) {io.fabric8.kubernetes.api.model.NodeBuilder builder = new io.fabric8.kubernetes.api.model.NodeBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromNodeItems(io.fabric8.kubernetes.api.model.Node... items) {
    for (io.fabric8.kubernetes.api.model.Node item : items) {io.fabric8.kubernetes.api.model.NodeBuilder builder = new io.fabric8.kubernetes.api.model.NodeBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromNodeItems(java.util.Collection<io.fabric8.kubernetes.api.model.Node> items) {
    for (io.fabric8.kubernetes.api.model.Node item : items) {io.fabric8.kubernetes.api.model.NodeBuilder builder = new io.fabric8.kubernetes.api.model.NodeBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromNodeItems(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (items == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public BaseKubernetesListFluent.NodeItemsNested<A> addNewNodeItem() {
    return new BaseKubernetesListFluentImpl.NodeItemsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.NodeItemsNested<A> addNewNodeItemLike(io.fabric8.kubernetes.api.model.Node item) {
    return new io.fabric8.kubernetes.api.model.BaseKubernetesListFluentImpl.NodeItemsNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.NodeItemsNested<A> setNewNodeItemLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.Node item) {
    return new io.fabric8.kubernetes.api.model.BaseKubernetesListFluentImpl.NodeItemsNestedImpl(index, item);
  }
  public A addToServiceAccountItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.ServiceAccount item) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    ServiceAccountBuilder builder = new io.fabric8.kubernetes.api.model.ServiceAccountBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
  }
  public A setToServiceAccountItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.ServiceAccount item) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.kubernetes.api.model.ServiceAccountBuilder builder = new io.fabric8.kubernetes.api.model.ServiceAccountBuilder(item);
    if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
    if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
     return (A)this;
  }
  public A addToServiceAccountItems(io.fabric8.kubernetes.api.model.ServiceAccount... items) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.kubernetes.api.model.ServiceAccount item : items) {io.fabric8.kubernetes.api.model.ServiceAccountBuilder builder = new io.fabric8.kubernetes.api.model.ServiceAccountBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToServiceAccountItems(java.util.Collection<io.fabric8.kubernetes.api.model.ServiceAccount> items) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.kubernetes.api.model.ServiceAccount item : items) {io.fabric8.kubernetes.api.model.ServiceAccountBuilder builder = new io.fabric8.kubernetes.api.model.ServiceAccountBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromServiceAccountItems(io.fabric8.kubernetes.api.model.ServiceAccount... items) {
    for (io.fabric8.kubernetes.api.model.ServiceAccount item : items) {io.fabric8.kubernetes.api.model.ServiceAccountBuilder builder = new io.fabric8.kubernetes.api.model.ServiceAccountBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromServiceAccountItems(java.util.Collection<io.fabric8.kubernetes.api.model.ServiceAccount> items) {
    for (io.fabric8.kubernetes.api.model.ServiceAccount item : items) {io.fabric8.kubernetes.api.model.ServiceAccountBuilder builder = new io.fabric8.kubernetes.api.model.ServiceAccountBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromServiceAccountItems(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (items == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public BaseKubernetesListFluent.ServiceAccountItemsNested<A> addNewServiceAccountItem() {
    return new BaseKubernetesListFluentImpl.ServiceAccountItemsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.ServiceAccountItemsNested<A> addNewServiceAccountItemLike(io.fabric8.kubernetes.api.model.ServiceAccount item) {
    return new io.fabric8.kubernetes.api.model.BaseKubernetesListFluentImpl.ServiceAccountItemsNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.ServiceAccountItemsNested<A> setNewServiceAccountItemLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.ServiceAccount item) {
    return new io.fabric8.kubernetes.api.model.BaseKubernetesListFluentImpl.ServiceAccountItemsNestedImpl(index, item);
  }
  public java.lang.String getKind() {
    return this.kind;
  }
  public A withKind(java.lang.String kind) {
    this.kind=kind; return (A) this;
  }
  public java.lang.Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public ListMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public io.fabric8.kubernetes.api.model.ListMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(io.fabric8.kubernetes.api.model.ListMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new io.fabric8.kubernetes.api.model.ListMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
  }
  public java.lang.Boolean hasMetadata() {
    return this.metadata != null;
  }
  public A withNewMetadata(java.lang.String _continue,Long remainingItemCount,java.lang.String resourceVersion,java.lang.String selfLink) {
    return (A)withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
  }
  public BaseKubernetesListFluent.MetadataNested<A> withNewMetadata() {
    return new BaseKubernetesListFluentImpl.MetadataNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.MetadataNested<A> withNewMetadataLike(io.fabric8.kubernetes.api.model.ListMeta item) {
    return new io.fabric8.kubernetes.api.model.BaseKubernetesListFluentImpl.MetadataNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new io.fabric8.kubernetes.api.model.ListMetaBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.MetadataNested<A> editOrNewMetadataLike(io.fabric8.kubernetes.api.model.ListMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    BaseKubernetesListFluentImpl that = (BaseKubernetesListFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (items != null ? !items.equals(that.items) :that.items != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  items,  kind,  metadata,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (items != null && !items.isEmpty()) { sb.append("items:"); sb.append(items + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class LimitRangeItemsNestedImpl<N> extends LimitRangeFluentImpl<BaseKubernetesListFluent.LimitRangeItemsNested<N>> implements io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.LimitRangeItemsNested<N>,Nested<N>{
    LimitRangeItemsNestedImpl(java.lang.Integer index,LimitRange item) {
      this.index = index;
      this.builder = new LimitRangeBuilder(this, item);
    }
    LimitRangeItemsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.LimitRangeBuilder(this);
    }
    io.fabric8.kubernetes.api.model.LimitRangeBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) BaseKubernetesListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endLimitRangeItem() {
      return and();
    }
    
  }
  class APIServiceItemsNestedImpl<N> extends APIServiceFluentImpl<BaseKubernetesListFluent.APIServiceItemsNested<N>> implements io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.APIServiceItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    APIServiceItemsNestedImpl(java.lang.Integer index,APIService item) {
      this.index = index;
      this.builder = new APIServiceBuilder(this, item);
    }
    APIServiceItemsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.APIServiceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.APIServiceBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) BaseKubernetesListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endAPIServiceItem() {
      return and();
    }
    
  }
  class NamespaceItemsNestedImpl<N> extends NamespaceFluentImpl<BaseKubernetesListFluent.NamespaceItemsNested<N>> implements io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.NamespaceItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    NamespaceItemsNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.Namespace item) {
      this.index = index;
      this.builder = new NamespaceBuilder(this, item);
    }
    NamespaceItemsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.NamespaceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.NamespaceBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) BaseKubernetesListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endNamespaceItem() {
      return and();
    }
    
  }
  class ServiceItemsNestedImpl<N> extends ServiceFluentImpl<BaseKubernetesListFluent.ServiceItemsNested<N>> implements io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.ServiceItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ServiceItemsNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.Service item) {
      this.index = index;
      this.builder = new ServiceBuilder(this, item);
    }
    ServiceItemsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.ServiceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ServiceBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) BaseKubernetesListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endServiceItem() {
      return and();
    }
    
  }
  class ReplicationControllerItemsNestedImpl<N> extends ReplicationControllerFluentImpl<BaseKubernetesListFluent.ReplicationControllerItemsNested<N>> implements io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.ReplicationControllerItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ReplicationControllerItemsNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.ReplicationController item) {
      this.index = index;
      this.builder = new ReplicationControllerBuilder(this, item);
    }
    ReplicationControllerItemsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.ReplicationControllerBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ReplicationControllerBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) BaseKubernetesListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endReplicationControllerItem() {
      return and();
    }
    
  }
  class PodTemplateItemsNestedImpl<N> extends PodTemplateFluentImpl<BaseKubernetesListFluent.PodTemplateItemsNested<N>> implements io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.PodTemplateItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    PodTemplateItemsNestedImpl(java.lang.Integer index,PodTemplate item) {
      this.index = index;
      this.builder = new PodTemplateBuilder(this, item);
    }
    PodTemplateItemsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.PodTemplateBuilder(this);
    }
    io.fabric8.kubernetes.api.model.PodTemplateBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) BaseKubernetesListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endPodTemplateItem() {
      return and();
    }
    
  }
  class EventItemsNestedImpl<N> extends EventFluentImpl<BaseKubernetesListFluent.EventItemsNested<N>> implements io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.EventItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    EventItemsNestedImpl(java.lang.Integer index,Event item) {
      this.index = index;
      this.builder = new EventBuilder(this, item);
    }
    EventItemsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.EventBuilder(this);
    }
    io.fabric8.kubernetes.api.model.EventBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) BaseKubernetesListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endEventItem() {
      return and();
    }
    
  }
  class PersistentVolumeItemsNestedImpl<N> extends PersistentVolumeFluentImpl<BaseKubernetesListFluent.PersistentVolumeItemsNested<N>> implements io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.PersistentVolumeItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    PersistentVolumeItemsNestedImpl(java.lang.Integer index,PersistentVolume item) {
      this.index = index;
      this.builder = new PersistentVolumeBuilder(this, item);
    }
    PersistentVolumeItemsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.PersistentVolumeBuilder(this);
    }
    io.fabric8.kubernetes.api.model.PersistentVolumeBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) BaseKubernetesListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endPersistentVolumeItem() {
      return and();
    }
    
  }
  class PersistentVolumeClaimItemsNestedImpl<N> extends PersistentVolumeClaimFluentImpl<BaseKubernetesListFluent.PersistentVolumeClaimItemsNested<N>> implements io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.PersistentVolumeClaimItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    PersistentVolumeClaimItemsNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.PersistentVolumeClaim item) {
      this.index = index;
      this.builder = new PersistentVolumeClaimBuilder(this, item);
    }
    PersistentVolumeClaimItemsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder(this);
    }
    io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) BaseKubernetesListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endPersistentVolumeClaimItem() {
      return and();
    }
    
  }
  class GenericKubernetesResourceItemsNestedImpl<N> extends GenericKubernetesResourceFluentImpl<BaseKubernetesListFluent.GenericKubernetesResourceItemsNested<N>> implements io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.GenericKubernetesResourceItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    GenericKubernetesResourceItemsNestedImpl(java.lang.Integer index,GenericKubernetesResource item) {
      this.index = index;
      this.builder = new GenericKubernetesResourceBuilder(this, item);
    }
    GenericKubernetesResourceItemsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.GenericKubernetesResourceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.GenericKubernetesResourceBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) BaseKubernetesListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endGenericKubernetesResourceItem() {
      return and();
    }
    
  }
  class EndpointsItemsNestedImpl<N> extends EndpointsFluentImpl<BaseKubernetesListFluent.EndpointsItemsNested<N>> implements io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.EndpointsItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    EndpointsItemsNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.Endpoints item) {
      this.index = index;
      this.builder = new EndpointsBuilder(this, item);
    }
    EndpointsItemsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.EndpointsBuilder(this);
    }
    io.fabric8.kubernetes.api.model.EndpointsBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) BaseKubernetesListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endEndpointsItem() {
      return and();
    }
    
  }
  class PodItemsNestedImpl<N> extends PodFluentImpl<BaseKubernetesListFluent.PodItemsNested<N>> implements io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.PodItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    PodItemsNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.Pod item) {
      this.index = index;
      this.builder = new PodBuilder(this, item);
    }
    PodItemsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.PodBuilder(this);
    }
    io.fabric8.kubernetes.api.model.PodBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) BaseKubernetesListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endPodItem() {
      return and();
    }
    
  }
  class ConfigMapItemsNestedImpl<N> extends ConfigMapFluentImpl<BaseKubernetesListFluent.ConfigMapItemsNested<N>> implements io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.ConfigMapItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ConfigMapItemsNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.ConfigMap item) {
      this.index = index;
      this.builder = new ConfigMapBuilder(this, item);
    }
    ConfigMapItemsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.ConfigMapBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ConfigMapBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) BaseKubernetesListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endConfigMapItem() {
      return and();
    }
    
  }
  class ComponentStatusItemsNestedImpl<N> extends ComponentStatusFluentImpl<BaseKubernetesListFluent.ComponentStatusItemsNested<N>> implements io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.ComponentStatusItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ComponentStatusItemsNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.ComponentStatus item) {
      this.index = index;
      this.builder = new ComponentStatusBuilder(this, item);
    }
    ComponentStatusItemsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.ComponentStatusBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ComponentStatusBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) BaseKubernetesListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endComponentStatusItem() {
      return and();
    }
    
  }
  class BindingItemsNestedImpl<N> extends BindingFluentImpl<BaseKubernetesListFluent.BindingItemsNested<N>> implements io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.BindingItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    BindingItemsNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.Binding item) {
      this.index = index;
      this.builder = new BindingBuilder(this, item);
    }
    BindingItemsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.BindingBuilder(this);
    }
    io.fabric8.kubernetes.api.model.BindingBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) BaseKubernetesListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endBindingItem() {
      return and();
    }
    
  }
  class ResourceQuotaItemsNestedImpl<N> extends ResourceQuotaFluentImpl<BaseKubernetesListFluent.ResourceQuotaItemsNested<N>> implements io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.ResourceQuotaItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ResourceQuotaItemsNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.ResourceQuota item) {
      this.index = index;
      this.builder = new ResourceQuotaBuilder(this, item);
    }
    ResourceQuotaItemsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.ResourceQuotaBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ResourceQuotaBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) BaseKubernetesListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endResourceQuotaItem() {
      return and();
    }
    
  }
  class SecretItemsNestedImpl<N> extends SecretFluentImpl<BaseKubernetesListFluent.SecretItemsNested<N>> implements io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.SecretItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    SecretItemsNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.Secret item) {
      this.index = index;
      this.builder = new SecretBuilder(this, item);
    }
    SecretItemsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.SecretBuilder(this);
    }
    io.fabric8.kubernetes.api.model.SecretBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) BaseKubernetesListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endSecretItem() {
      return and();
    }
    
  }
  class NodeItemsNestedImpl<N> extends NodeFluentImpl<BaseKubernetesListFluent.NodeItemsNested<N>> implements io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.NodeItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    NodeItemsNestedImpl(java.lang.Integer index,Node item) {
      this.index = index;
      this.builder = new NodeBuilder(this, item);
    }
    NodeItemsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.NodeBuilder(this);
    }
    io.fabric8.kubernetes.api.model.NodeBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) BaseKubernetesListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endNodeItem() {
      return and();
    }
    
  }
  class ServiceAccountItemsNestedImpl<N> extends ServiceAccountFluentImpl<BaseKubernetesListFluent.ServiceAccountItemsNested<N>> implements io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.ServiceAccountItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ServiceAccountItemsNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.ServiceAccount item) {
      this.index = index;
      this.builder = new ServiceAccountBuilder(this, item);
    }
    ServiceAccountItemsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.ServiceAccountBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ServiceAccountBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) BaseKubernetesListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endServiceAccountItem() {
      return and();
    }
    
  }
  class MetadataNestedImpl<N> extends ListMetaFluentImpl<BaseKubernetesListFluent.MetadataNested<N>> implements io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    MetadataNestedImpl(ListMeta item) {
      this.builder = new ListMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ListMetaBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ListMetaBuilder builder;
    public N and() {
      return (N) BaseKubernetesListFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  
}