package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BindingBuilder extends BindingFluentImpl<BindingBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.Binding,io.fabric8.kubernetes.api.model.BindingBuilder>{
  public BindingBuilder() {
    this(false);
  }
  public BindingBuilder(Boolean validationEnabled) {
    this(new Binding(), validationEnabled);
  }
  public BindingBuilder(BindingFluent<?> fluent) {
    this(fluent, false);
  }
  public BindingBuilder(io.fabric8.kubernetes.api.model.BindingFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Binding(), validationEnabled);
  }
  public BindingBuilder(io.fabric8.kubernetes.api.model.BindingFluent<?> fluent,io.fabric8.kubernetes.api.model.Binding instance) {
    this(fluent, instance, false);
  }
  public BindingBuilder(io.fabric8.kubernetes.api.model.BindingFluent<?> fluent,io.fabric8.kubernetes.api.model.Binding instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withTarget(instance.getTarget()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public BindingBuilder(io.fabric8.kubernetes.api.model.Binding instance) {
    this(instance,false);
  }
  public BindingBuilder(io.fabric8.kubernetes.api.model.Binding instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withTarget(instance.getTarget()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.BindingFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.Binding build() {
    Binding buildable = new Binding(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getTarget());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}